/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.model;

import io.intino.sumus.util.Formatters;
import io.intino.sumus.util.Json;
import java.util.HashMap;
import java.util.Map;

public abstract class AttributeDefinition {
    private static final AttributeBuilder nullBuilder = (n, p) -> null;
    private static final Map<String, AttributeBuilder> builders = new HashMap<String, AttributeBuilder>(){
        {
            this.put(Category.class.getSimpleName(), (n, p) -> new Category(n));
            this.put(Int.class.getSimpleName(), (n, p) -> new Int(n));
            this.put(Int8.class.getSimpleName(), (n, p) -> new Int8(n));
            this.put(Int16.class.getSimpleName(), (n, p) -> new Int16(n));
            this.put(Int32.class.getSimpleName(), (n, p) -> new Int32(n));
            this.put(Int64.class.getSimpleName(), (n, p) -> new Int64(n));
            this.put(Real.class.getSimpleName(), (n, p) -> new Real(n));
            this.put(Real32.class.getSimpleName(), (n, p) -> new Real32(n));
            this.put(Real64.class.getSimpleName(), (n, p) -> new Real64(n));
            this.put(Label.class.getSimpleName(), (n, p) -> new Label(n));
            this.put(Date.class.getSimpleName(), (n, p) -> new Date(n));
            this.put(Key.class.getSimpleName(), (n, p) -> new Key(n, p.length == 0 ? "" : p[0]));
            this.put(Url.class.getSimpleName(), (n, p) -> p.length != 1 ? null : new Url(n, p[0]));
        }
    };
    private final String name;
    private final Type type;

    public static AttributeDefinition create(String type, String name, String ... parameters) {
        return builders.getOrDefault(Formatters.firstUpperCase(type), nullBuilder).build(name, parameters);
    }

    public AttributeDefinition(String name) {
        this.name = name;
        this.type = Type.valueOf(this.getClass().getSimpleName().toLowerCase());
    }

    public AttributeDefinition(String name, Type type) {
        this.name = name;
        this.type = type;
    }

    public Type type() {
        return this.type;
    }

    public boolean isNumeric() {
        return this.type.isNumeric();
    }

    public boolean isOrdinal() {
        return this.type.isOrdinal();
    }

    public String name() {
        return this.name;
    }

    public boolean isReal() {
        return this.type().isReal();
    }

    public String toString() {
        return Json.toJsonPretty(this);
    }

    public static enum Type {
        int8,
        int16,
        int32,
        int64,
        real32,
        real64,
        label,
        category,
        date,
        key,
        url;


        public boolean isNumeric() {
            return this.isInteger() || this.isReal();
        }

        public boolean isReal() {
            return this == real32 || this == real64;
        }

        public boolean isInteger() {
            return this == int8 || this == int16 || this == int32 || this == int64;
        }

        public boolean isOrdinal() {
            return this.isNumeric() || this == date;
        }
    }

    private static interface AttributeBuilder {
        public AttributeDefinition build(String var1, String ... var2);
    }

    public static class Url
    extends AttributeDefinition {
        private final String path;

        public Url(String name, String path) {
            super(name);
            this.path = path;
        }

        public String path() {
            return this.path;
        }
    }

    public static class Key
    extends AttributeDefinition {
        private final String ledgerJoin;

        public Key(String name, String ledgerJoin) {
            super(name);
            this.ledgerJoin = ledgerJoin;
        }

        public String ledgerJoin() {
            return this.ledgerJoin;
        }
    }

    public static class Label
    extends AttributeDefinition {
        public Label(String name) {
            super(name);
        }
    }

    public static class Date
    extends AttributeDefinition {
        public Date(String name) {
            super(name);
        }
    }

    public static class Real64
    extends AttributeDefinition {
        public Real64(String name) {
            super(name, Type.real64);
        }
    }

    public static class Real32
    extends AttributeDefinition {
        public Real32(String name) {
            super(name);
        }
    }

    public static class Real
    extends Real64 {
        public Real(String name) {
            super(name);
        }
    }

    public static class Int64
    extends AttributeDefinition {
        public Int64(String name) {
            super(name, Type.int64);
        }
    }

    public static class Int32
    extends AttributeDefinition {
        public Int32(String name) {
            super(name);
        }
    }

    public static class Int16
    extends AttributeDefinition {
        public Int16(String name) {
            super(name);
        }
    }

    public static class Int8
    extends AttributeDefinition {
        public Int8(String name) {
            super(name);
        }
    }

    public static class Int
    extends Int64 {
        public Int(String name) {
            super(name);
        }
    }

    public static class Category
    extends AttributeDefinition {
        public Category(String name) {
            super(name);
        }
    }
}

