/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus;

import io.intino.sumus.DimensionBuilder;
import io.intino.sumus.IndicatorBuilder;
import io.intino.sumus.model.AttributeDefinition;
import io.intino.sumus.model.LedgerDefinition;
import io.intino.sumus.parser.SumusGrammar;
import io.intino.sumus.parser.SumusParser;
import io.intino.sumus.util.ParseUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.text.ParseException;
import java.util.List;

public class LedgerDefinitionBuilder {
    private final File baseDirectory;

    public LedgerDefinitionBuilder(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public LedgerDefinition build(File definition) throws ParseException {
        try {
            return this.build(Files.readString(definition.toPath(), Charset.defaultCharset()));
        }
        catch (IOException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    public LedgerDefinition build(InputStream definition) throws ParseException {
        try {
            return this.build(new String(definition.readAllBytes()));
        }
        catch (IOException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    public LedgerDefinition build(String definition) throws ParseException {
        SumusGrammar.RootContext rootContext = new SumusParser(definition).parse();
        LedgerDefinition ledger = this.createLedger(ParseUtils.findSection(rootContext, "properties"));
        this.fillAttributes(ledger, ParseUtils.findSection(rootContext, "attributes"));
        this.fillIndicators(ledger, ParseUtils.safeFindSection(rootContext, "indicators"));
        this.fillDimensions(ledger, ParseUtils.safeFindSection(rootContext, "dimensions"));
        return ledger;
    }

    private void fillAttributes(LedgerDefinition ledger, List<SumusGrammar.DeclarationContext> attributes) throws ParseException {
        for (SumusGrammar.DeclarationContext attribute : attributes) {
            AttributeDefinition attr = AttributeDefinition.create(attribute.IDENTIFIER().getText(), attribute.name().getText(), this.parameters(attribute));
            if (attr == null) {
                throw new ParseException("Error parsing attribute: " + attribute.getText(), 0);
            }
            ledger.add(attr);
        }
    }

    private String[] parameters(SumusGrammar.DeclarationContext attribute) {
        if (attribute.parameters() == null) {
            return new String[0];
        }
        return (String[])attribute.parameters().parameter().stream().map(p -> p.value().getText().replace("\"", "")).toArray(String[]::new);
    }

    private void fillIndicators(LedgerDefinition ledger, List<SumusGrammar.DeclarationContext> indicators) throws ParseException {
        IndicatorBuilder builder = new IndicatorBuilder();
        for (SumusGrammar.DeclarationContext indicator : indicators) {
            ledger.add(builder.build(indicator, ledger));
        }
    }

    private void fillDimensions(LedgerDefinition ledger, List<SumusGrammar.DeclarationContext> dimensions) throws ParseException {
        DimensionBuilder builder = new DimensionBuilder(this.baseDirectory);
        for (SumusGrammar.DeclarationContext dimension : dimensions) {
            ledger.add(builder.build(dimension, ledger));
        }
    }

    private LedgerDefinition createLedger(List<SumusGrammar.DeclarationContext> declarations) throws ParseException {
        SumusGrammar.DeclarationContext content = ParseUtils.findDeclaration(declarations, "content");
        if (content == null) {
            throw new ParseException("Property 'content' not found", 0);
        }
        SumusGrammar.DeclarationContext format = ParseUtils.findDeclaration(declarations, "format");
        if (format == null) {
            throw new ParseException("Property 'format' not found", 0);
        }
        SumusGrammar.DeclarationContext aggregations = ParseUtils.findDeclaration(declarations, "aggregations");
        String aggregationKey = ParseUtils.findDeclarationValue(declarations, "aggregation-key");
        return new LedgerDefinition(ParseUtils.parseContent(content), ParseUtils.parseFormat(format), ParseUtils.parseAggregations(aggregations), aggregationKey);
    }
}

