/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus;

import io.intino.sumus.model.AttributeDefinition;
import io.intino.sumus.model.IndicatorDefinition;
import io.intino.sumus.model.LedgerDefinition;
import io.intino.sumus.parser.SumusGrammar;
import io.intino.sumus.util.ParseUtils;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class IndicatorBuilder {
    public IndicatorDefinition build(SumusGrammar.DeclarationContext i, LedgerDefinition ledger) throws ParseException {
        SumusGrammar.ValueContext attr = ParseUtils.findParameterByNameOrPosition(i.parameters().parameter(), "attribute", 0);
        AttributeDefinition attribute = ledger.attribute(attr.getText());
        if (attribute == null) {
            throw new ParseException("Attribute '" + attr.getText() + "' not found for: " + i.name().getText(), 0);
        }
        return this.createIndicator(i, attribute);
    }

    private IndicatorDefinition createIndicator(SumusGrammar.DeclarationContext i, AttributeDefinition attr) throws ParseException {
        String name = i.name().getText();
        IndicatorDefinition.Function function = this.parseFunction(i.IDENTIFIER().getText());
        String unit = this.parseUnit(IndicatorBuilder.findParameter(i.parameters().parameter(), "unit"));
        IndicatorDefinition.Scale scale = this.parseScale(IndicatorBuilder.findParameter(i.parameters().parameter(), "scale"));
        List<String> values = this.parseValues(IndicatorBuilder.findParameter(i.parameters().parameter(), "values"));
        return new IndicatorDefinition(name, function, attr, unit, scale, values);
    }

    private IndicatorDefinition.Function parseFunction(String function) throws ParseException {
        return Arrays.stream(IndicatorDefinition.Function.values()).filter(f -> f.label.equals(function)).findFirst().orElseThrow(() -> new ParseException("Formula not found '" + function + "'", 0));
    }

    private IndicatorDefinition.Scale parseScale(SumusGrammar.ValueContext scale) throws ParseException {
        if (scale == null) {
            return null;
        }
        if (scale.range().size() != 1) {
            throw new ParseException("Scale '" + scale.getText() + "' not well formatted", 0);
        }
        List<SumusGrammar.IntegerValueContext> values = scale.range().get(0).integerValue();
        return new IndicatorDefinition.Scale(Double.parseDouble(values.get(0).getText()), Double.parseDouble(values.get(1).getText()));
    }

    private List<String> parseValues(SumusGrammar.ValueContext value) {
        if (value == null) {
            return Collections.emptyList();
        }
        return value.STRING().stream().map(s -> this.cleanString(s.getText())).collect(Collectors.toUnmodifiableList());
    }

    private String parseUnit(SumusGrammar.ValueContext unit) throws ParseException {
        if (unit == null) {
            return null;
        }
        if (unit.STRING().size() != 1) {
            throw new ParseException("Unit '" + unit.getText() + "' not well formatted", 0);
        }
        return unit.STRING().get(0).getText().replace("\"", "");
    }

    private static SumusGrammar.ValueContext findParameter(List<SumusGrammar.ParameterContext> parameters, String name) {
        try {
            return ParseUtils.findParameter(parameters, name);
        }
        catch (ParseException ignored) {
            return null;
        }
    }

    private String cleanString(String value) {
        return value.replace("\"", "");
    }
}

