/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus;

import io.intino.sumus.model.AttributeDefinition;
import io.intino.sumus.model.DimensionDefinition;
import io.intino.sumus.model.LedgerDefinition;
import io.intino.sumus.parser.SumusGrammar;
import io.intino.sumus.util.ParseUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.TerminalNode;

public class DimensionBuilder {
    private final File baseDirectory;

    public DimensionBuilder(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public DimensionDefinition build(SumusGrammar.DeclarationContext d, LedgerDefinition ledger) throws ParseException {
        SumusGrammar.ValueContext attr = ParseUtils.findParameterByNameOrPosition(d.parameters().parameter(), "attribute", 0);
        AttributeDefinition attribute = ledger.attribute(attr.getText());
        if (attribute == null) {
            throw new ParseException("Attribute '" + attr.getText() + "' not found for: " + d.name(), 0);
        }
        String type = d.IDENTIFIER().getText();
        if ("numerical".equals(type)) {
            return this.createNumerical(d, attribute);
        }
        if ("categorical".equals(type)) {
            return this.createCategorical(d, attribute);
        }
        throw new ParseException("Unknown dimension type: " + type, 0);
    }

    private DimensionDefinition createNumerical(SumusGrammar.DeclarationContext dimension, AttributeDefinition attribute) throws ParseException {
        return new DimensionDefinition.Numerical(dimension.name().getText(), attribute, this.createNumericalCategories(dimension, attribute));
    }

    private DimensionDefinition createCategorical(SumusGrammar.DeclarationContext dimension, AttributeDefinition attribute) throws ParseException {
        return new DimensionDefinition.Categorical(dimension.name().getText(), attribute, this.createCategoricalCategories(dimension));
    }

    private Map<String, Predicate<?>> createNumericalCategories(SumusGrammar.DeclarationContext dimension, AttributeDefinition attribute) throws ParseException {
        try {
            return this.mapRanges(ParseUtils.findParameter(dimension.parameters().parameter(), "ranges").integerValue(), attribute);
        }
        catch (ParseException parseException) {
            return this.mapNumericalSlices(this.clean(ParseUtils.findParameter(dimension.parameters().parameter(), "slices").STRING()), attribute);
        }
    }

    private Map<String, Predicate<?>> createCategoricalCategories(SumusGrammar.DeclarationContext dimension) throws ParseException {
        try {
            return this.mapCategoricalSlices(this.clean(ParseUtils.findParameter(dimension.parameters().parameter(), "slices").STRING()));
        }
        catch (ParseException parseException) {
            return this.mapFromResource(this.clean(ParseUtils.findParameter(dimension.parameters().parameter(), "from").STRING()).get(0));
        }
    }

    private Map<String, Predicate<?>> mapNumericalSlices(List<String> slices, AttributeDefinition attribute) throws ParseException {
        LinkedHashMap categories = new LinkedHashMap();
        for (String slice : slices) {
            String[] keyValue = this.parseSlice(slice);
            Matcher matcher = this.rangePattern(keyValue[1]);
            if (!matcher.matches()) {
                throw new ParseException("Slice not well formatted. Pattern didn't match. " + slice, 0);
            }
            categories.put(keyValue[0], this.numericalSlicePredicate(matcher, keyValue[1], attribute));
        }
        return categories;
    }

    private Predicate<?> numericalSlicePredicate(Matcher matcher, String slice, AttributeDefinition attribute) throws ParseException {
        if (slice.startsWith("[") || matcher.group(2).equals("~")) {
            return this.leftClosedPredicate(attribute, DimensionBuilder.parse(matcher.group(2)), DimensionBuilder.parse(matcher.group(5)));
        }
        if (slice.endsWith("]") || matcher.group(5).equals("~")) {
            return this.rightClosedPredicate(attribute, DimensionBuilder.parse(matcher.group(0)), DimensionBuilder.parse(matcher.group(1)));
        }
        throw new ParseException("Slice not well formatted. Missing closed interval. " + slice, 0);
    }

    private Map<String, Predicate<?>> mapCategoricalSlices(List<String> slices) throws ParseException {
        LinkedHashMap categories = new LinkedHashMap();
        for (String slice : slices) {
            String[] keyValue = this.parseSlice(slice);
            categories.put(keyValue[0], Pattern.compile(keyValue[1]).asMatchPredicate());
        }
        return categories;
    }

    private Map<String, Predicate<?>> mapFromResource(String resource) throws ParseException {
        LinkedHashMap categories = new LinkedHashMap();
        File file = new File(this.baseDirectory, resource);
        if (!file.exists()) {
            throw new ParseException("Resource " + file.getAbsolutePath() + " not found", 0);
        }
        try {
            List<String> lines = Files.readAllLines(file.toPath());
            lines.stream().map(l -> l.split("\t")).forEach(l -> categories.put(l[0], Pattern.compile(l[1]).asMatchPredicate()));
            return categories;
        }
        catch (IOException e) {
            throw new ParseException("Resource " + file.getAbsolutePath() + "cannot be loaded", 0);
        }
    }

    private String[] parseSlice(String slice) throws ParseException {
        String[] keyValue = slice.split("\\|");
        if (keyValue.length != 2) {
            throw new ParseException("Slice not well formatted. Should have '|' separator. " + slice, 0);
        }
        return keyValue;
    }

    private List<String> clean(List<TerminalNode> node) {
        return node.stream().map(n -> this.cleanString(n.getText())).collect(Collectors.toList());
    }

    private String cleanString(String value) {
        return value.replace("\"", "");
    }

    private Map<String, Predicate<?>> mapRanges(List<SumusGrammar.IntegerValueContext> ranges, AttributeDefinition attr) {
        Long[] longs = this.asLongs(ranges.stream().map(RuleContext::getText));
        List<String> categories = this.categoriesOf(longs);
        return IntStream.range(0, categories.size()).boxed().collect(Collectors.toMap(categories::get, pos -> this.leftClosedPredicate(attr, longs[pos], longs[pos + 1]), (a, b) -> b, LinkedHashMap::new));
    }

    private Predicate<?> leftClosedPredicate(AttributeDefinition attr, Long left, Long right) {
        return attr.isReal() ? this.doublePredicate(v -> Objects.isNull(left) || this.toDouble(v) >= (double)left.longValue(), v -> Objects.isNull(right) || this.toDouble(v) < (double)right.longValue()) : this.longPredicate(v -> Objects.isNull(left) || this.toLong(v) >= left, v -> Objects.isNull(right) || this.toLong(v) < right);
    }

    private Predicate<?> rightClosedPredicate(AttributeDefinition attr, Long left, Long right) {
        return attr.isReal() ? this.doublePredicate(v -> Objects.isNull(left) || this.toDouble(v) > (double)left.longValue(), v -> Objects.isNull(right) || this.toDouble(v) <= (double)right.longValue()) : this.longPredicate(v -> Objects.isNull(left) || this.toLong(v) > left, v -> Objects.isNull(right) || this.toLong(v) <= right);
    }

    private Predicate<Object> longPredicate(Predicate<Object> left, Predicate<Object> right) {
        return v -> !Objects.isNull(v) && left.test(this.toLong(v)) && right.test(this.toLong(v));
    }

    private Predicate<Object> doublePredicate(Predicate<Object> left, Predicate<Object> right) {
        return v -> !Objects.isNull(v) && left.test(this.toDouble(v)) && right.test(this.toDouble(v));
    }

    private long toLong(Object v) {
        return ((Number)v).longValue();
    }

    private double toDouble(Object v) {
        return ((Number)v).doubleValue();
    }

    private Long[] asLongs(Stream<String> options) {
        return (Long[])options.map(DimensionBuilder::parse).toArray(Long[]::new);
    }

    private Matcher rangePattern(String range) {
        String patternStr = "([\\[(])((\\d+)|~),\\s?((\\d+)|~)(]|\\))";
        Pattern pattern = Pattern.compile(patternStr);
        return pattern.matcher(range);
    }

    private List<String> categoriesOf(Long[] longs) {
        return IntStream.range(0, longs.length - 1).mapToObj(i -> DimensionBuilder.clean("[" + longs[i] + ".." + longs[i + 1] + "]")).collect(Collectors.toList());
    }

    private static Long parse(String s) {
        try {
            if (s == null) {
                return null;
            }
            return Long.parseLong(s.trim());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static String clean(String value) {
        return value.replace("null", "");
    }
}

