/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.dimensions;

import io.intino.sumus.engine.Lookup;
import io.intino.sumus.engine.Slice;
import io.intino.sumus.engine.SumusException;
import io.intino.sumus.engine.dimensions.AbstractDimension;
import io.intino.sumus.engine.model.AttributeDefinition;
import java.time.LocalDate;
import java.time.Month;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class YearMonthDimension
extends AbstractDimension {
    public YearMonthDimension(Lookup lookup) {
        super(lookup);
        this.slices.addAll(this.buildSlices());
        if (lookup.hasNA()) {
            this.slices.add(new AbstractDimension.DimensionSlice());
        }
    }

    @Override
    public String name() {
        return this.lookup.name() + "-year-month";
    }

    private List<Slice> buildSlices() {
        return this.years().boxed().flatMap(this::slicesOf).collect(Collectors.toList());
    }

    private Stream<Slice> slicesOf(int year) {
        return Arrays.stream(Month.values()).map(month -> this.sliceOf(year, (Month)month));
    }

    private AbstractDimension.DimensionSlice sliceOf(int year, Month month) {
        return new AbstractDimension.DimensionSlice(year + "-" + String.format("%02d", month.getValue()), v -> this.match(year, month, v));
    }

    @Override
    protected void check() {
        if (this.lookup.type() == AttributeDefinition.Type.date) {
            return;
        }
        throw new SumusException("YearMonth dimension must use a date column");
    }

    private boolean match(int year, Month month, Object value) {
        return value instanceof Long && LocalDate.ofEpochDay((Long)value).getMonth() == month && LocalDate.ofEpochDay((Long)value).getYear() == year;
    }

    private IntStream years() {
        try {
            int min = LocalDate.ofEpochDay((Long)this.lookup.min()).getYear();
            int max = LocalDate.ofEpochDay((Long)this.lookup.max()).getYear();
            return IntStream.range(min, max + 1);
        }
        catch (Exception e) {
            return IntStream.empty();
        }
    }
}

