/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.dimensions;

import io.intino.sumus.engine.Lookup;
import io.intino.sumus.engine.Slice;
import io.intino.sumus.engine.SumusException;
import io.intino.sumus.engine.dimensions.AbstractDimension;
import io.intino.sumus.engine.model.Classifier;
import java.util.List;
import java.util.stream.Collectors;

public class NumericalDimension
extends AbstractDimension {
    private final String name;

    public NumericalDimension(Lookup lookup, String name, Classifier classifier) {
        super(lookup);
        this.name = name;
        this.slices.addAll(this.slicesOf(classifier));
        if (lookup.hasNA()) {
            this.slices.add(new AbstractDimension.DimensionSlice());
        }
    }

    private List<Slice> slicesOf(Classifier classifier) {
        return classifier.categories().stream().map(c -> new AbstractDimension.DimensionSlice((String)c, classifier.predicateOf((String)c))).collect(Collectors.toList());
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    protected void check() {
        if (this.lookup.type().isNumeric()) {
            return;
        }
        throw new SumusException("Numerical dimension must use a numeric column");
    }
}

