/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.dimensions;

import io.intino.sumus.engine.Lookup;
import io.intino.sumus.engine.SumusException;
import io.intino.sumus.engine.dimensions.AbstractDimension;
import io.intino.sumus.engine.model.AttributeDefinition;
import java.time.LocalDate;
import java.time.Month;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class MonthOfYearDimension
extends AbstractDimension {
    public MonthOfYearDimension(Lookup lookup) {
        super(lookup);
        this.slices.addAll(this.buildSlices());
        if (lookup.hasNA()) {
            this.slices.add(new AbstractDimension.DimensionSlice());
        }
    }

    @Override
    public String name() {
        return this.lookup.name() + "-month-of-year";
    }

    private List<AbstractDimension.DimensionSlice> buildSlices() {
        return Arrays.stream(Month.values()).map(this::pointOf).collect(Collectors.toList());
    }

    @Override
    protected void check() {
        if (this.lookup.type() == AttributeDefinition.Type.date) {
            return;
        }
        throw new SumusException("MonthOfYear dimension must use a date column");
    }

    private AbstractDimension.DimensionSlice pointOf(Month month) {
        return new AbstractDimension.DimensionSlice(month.name().toLowerCase(), v -> this.match(month, v));
    }

    private boolean match(Month month, Object value) {
        return value instanceof Long && LocalDate.ofEpochDay((Long)value).getMonth() == month;
    }
}

