/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.dimensions;

import io.intino.sumus.engine.Lookup;
import io.intino.sumus.engine.Slice;
import io.intino.sumus.engine.SumusException;
import io.intino.sumus.engine.dimensions.AbstractDimension;
import io.intino.sumus.engine.dimensions.Category;
import io.intino.sumus.engine.model.AttributeDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class CategoricalDimension
extends AbstractDimension {
    public CategoricalDimension(Lookup lookup) {
        super(lookup);
        this.slices.addAll(this.buildSlices());
        if (lookup.hasNA()) {
            this.slices.add(new AbstractDimension.DimensionSlice());
        }
    }

    @Override
    protected void check() {
        if (this.lookup.type() == AttributeDefinition.Type.category) {
            return;
        }
        throw new SumusException("Categorical dimension must use a categorical column");
    }

    private List<Slice> buildSlices() {
        return this.buildSlices(this.categories());
    }

    private List<Category> categories() {
        return this.lookup.uniques().flatMap(v -> this.all(this.category(v)).stream()).distinct().collect(Collectors.toList());
    }

    private List<Slice> buildSlices(List<Category> categories) {
        HashMap<Category, AbstractDimension.DimensionSlice> slices = new HashMap<Category, AbstractDimension.DimensionSlice>();
        for (Category category : categories) {
            slices.put(category, this.sliceOf(category, (AbstractDimension.DimensionSlice)slices.get(category.parent)));
        }
        return categories.stream().map(slices::get).sorted(this::compare).collect(Collectors.toList());
    }

    private AbstractDimension.DimensionSlice sliceOf(Category category, AbstractDimension.DimensionSlice parent) {
        return new AbstractDimension.DimensionSlice(category.label, v -> v instanceof Category && this.match((Category)v, category), parent);
    }

    private boolean match(Category value, Category category) {
        return value != null && (value == category || this.match(value.parent, category));
    }

    private int compare(Slice a, Slice b) {
        return a.level() - b.level();
    }

    private List<Category> all(Category category) {
        if (category == null) {
            return new ArrayList<Category>();
        }
        List<Category> result = this.all(category.parent);
        result.add(category);
        return result;
    }

    private Category category(Object v) {
        return (Category)v;
    }

    @Override
    public int levels() {
        return this.slices.stream().mapToInt(Slice::level).max().orElse(1);
    }

    public List<Slice> slices(int level) {
        return this.slices.stream().filter(s -> s.level() == level || s.level() < level && !this.hasChildren((Slice)s)).collect(Collectors.toList());
    }

    private boolean hasChildren(Slice slice) {
        for (Slice s : this.slices) {
            AbstractDimension.DimensionSlice dimensionSlice = (AbstractDimension.DimensionSlice)s;
            if (dimensionSlice.parent != slice) continue;
            return true;
        }
        return false;
    }
}

