/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.builders.evaluators;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExpressionEvaluator {
    static final String OpenParenthesis = "(";
    static final String CloseParenthesis = ")";
    static final String Sum = "+";
    static final String Sub = "-";
    static final String Multiply = "*";
    static final String Divide = "/";
    static final String Modulus = "%";
    static final String NumberRegex = "-?\\d+(\\.\\d+)?";
    static final Pattern TokenPattern = Pattern.compile("\\d+(\\.\\d+)?|[-+*/%()]");
    static final Map<String, Integer> OperatorPrecedence = Map.of("+", 1, "-", 1, "*", 2, "/", 2, "%", 2);

    public static double evaluate(String formula) {
        return ExpressionEvaluator.evaluate(ExpressionEvaluator.toPostfix(ExpressionEvaluator.tokensOf(formula)));
    }

    private static double evaluate(List<String> postfixTokens) {
        ArrayDeque<Double> stack = new ArrayDeque<Double>();
        block14: for (String token : postfixTokens) {
            if (ExpressionEvaluator.isNumber(token)) {
                stack.push(Double.parseDouble(token));
                continue;
            }
            double b = (Double)stack.pop();
            double a = (Double)stack.pop();
            switch (token) {
                case "+": {
                    stack.push(a + b);
                    continue block14;
                }
                case "-": {
                    stack.push(a - b);
                    continue block14;
                }
                case "*": {
                    stack.push(a * b);
                    continue block14;
                }
                case "/": {
                    stack.push(b != 0.0 ? a / b : 0.0);
                    continue block14;
                }
                case "%": {
                    stack.push(a % b);
                    continue block14;
                }
            }
            throw new IllegalArgumentException("Unknown operator: " + token);
        }
        return (Double)stack.pop();
    }

    private static List<String> toPostfix(List<String> tokens) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayDeque<String> operators = new ArrayDeque<String>();
        for (int i = 0; i < tokens.size(); ++i) {
            String token = tokens.get(i);
            if (ExpressionEvaluator.isNumber(token)) {
                result.add(token);
                continue;
            }
            if (ExpressionEvaluator.isOperator(token)) {
                if (ExpressionEvaluator.isNegativeSymbol(token) && (i == 0 || !ExpressionEvaluator.isNumber(tokens.get(i - 1)))) {
                    result.add(Sub + tokens.get(++i));
                    continue;
                }
                while (!operators.isEmpty() && ExpressionEvaluator.isOperator((String)operators.peek()) && ExpressionEvaluator.hasMorePreference((String)operators.peek(), token)) {
                    result.add((String)operators.pop());
                }
                operators.push(token);
                continue;
            }
            if (ExpressionEvaluator.isOpenParenthesis(token)) {
                operators.push(token);
                continue;
            }
            if (!ExpressionEvaluator.isCloseParenthesis(token)) continue;
            while (!operators.isEmpty() && !ExpressionEvaluator.isOpenParenthesis((String)operators.peek())) {
                result.add((String)operators.pop());
            }
            operators.pop();
        }
        while (!operators.isEmpty()) {
            result.add((String)operators.pop());
        }
        return result;
    }

    private static List<String> tokensOf(String formula) {
        Matcher matcher = TokenPattern.matcher(formula);
        ArrayList<String> tokens = new ArrayList<String>();
        while (matcher.find()) {
            tokens.add(matcher.group());
        }
        return tokens;
    }

    private static boolean isOperatorOrOpenParenthesis(String token) {
        return ExpressionEvaluator.isOperator(token) || ExpressionEvaluator.isOpenParenthesis(token);
    }

    private static boolean hasMorePreference(String peekOperator, String token) {
        return OperatorPrecedence.get(peekOperator) >= OperatorPrecedence.get(token);
    }

    private static boolean isOperator(String token) {
        return OperatorPrecedence.containsKey(token);
    }

    private static boolean isOpenParenthesis(String token) {
        return OpenParenthesis.equals(token);
    }

    private static boolean isCloseParenthesis(String token) {
        return CloseParenthesis.equals(token);
    }

    private static boolean isNegativeSymbol(String token) {
        return Sub.equals(token);
    }

    private static boolean isNumber(String token) {
        return token.matches(NumberRegex);
    }
}

