/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.builders.deserializers;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.intino.sumus.engine.model.AttributeDefinition;
import io.intino.sumus.engine.model.CompositeIndicatorDefinition;
import io.intino.sumus.engine.model.IndicatorDefinition;
import io.intino.sumus.engine.model.SimpleIndicatorDefinition;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class IndicatorDefinitionDeserializer
implements JsonDeserializer<IndicatorDefinition> {
    private final Map<String, AttributeDefinition> attributes;

    public IndicatorDefinitionDeserializer(Map<String, AttributeDefinition> attributes) {
        this.attributes = attributes;
    }

    public IndicatorDefinition deserialize(JsonElement jsonElement, Type deserializerType, JsonDeserializationContext c) throws JsonParseException {
        JsonObject object = jsonElement.getAsJsonObject();
        String type = (String)c.deserialize(object.get("type"), String.class);
        IndicatorDefinition.Type indicatorType = IndicatorDefinition.Type.valueOf(type);
        switch (indicatorType) {
            case Simple: {
                return this.simpleIndicator(object, c);
            }
            case Composite: {
                return this.compositeIndicator(object, c);
            }
        }
        throw new JsonParseException("Unknown indicator definition type");
    }

    private IndicatorDefinition simpleIndicator(JsonObject object, JsonDeserializationContext c) {
        AttributeDefinition attribute = this.attribute(object, c);
        String name = (String)c.deserialize(object.get("name"), String.class);
        String unit = (String)c.deserialize(object.get("unit"), String.class);
        IndicatorDefinition.Scale scale = (IndicatorDefinition.Scale)c.deserialize(object.get("scale"), IndicatorDefinition.Scale.class);
        Integer decimals = (Integer)c.deserialize(object.get("decimals"), Integer.class);
        SimpleIndicatorDefinition.Function function = (SimpleIndicatorDefinition.Function)((Object)c.deserialize(object.get("function"), SimpleIndicatorDefinition.Function.class));
        List filteredValues = (List)c.deserialize(object.get("filteredValues"), List.class);
        return new SimpleIndicatorDefinition(name, function, attribute, unit, scale, filteredValues, decimals);
    }

    private IndicatorDefinition compositeIndicator(JsonObject object, JsonDeserializationContext c) {
        String name = (String)c.deserialize(object.get("name"), String.class);
        String unit = (String)c.deserialize(object.get("unit"), String.class);
        IndicatorDefinition.Scale scale = (IndicatorDefinition.Scale)c.deserialize(object.get("scale"), IndicatorDefinition.Scale.class);
        Integer decimals = (Integer)c.deserialize(object.get("decimals"), Integer.class);
        String formula = (String)c.deserialize(object.get("formula"), String.class);
        return new CompositeIndicatorDefinition(name, formula, unit, scale, decimals);
    }

    private AttributeDefinition attribute(JsonObject object, JsonDeserializationContext c) {
        AttributeDefinition attribute = (AttributeDefinition)c.deserialize(object.get("attribute"), AttributeDefinition.class);
        return attribute != null ? this.attributes.get(attribute.name()) : null;
    }
}

