/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.builders.deserializers;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.intino.sumus.engine.model.AttributeDefinition;
import io.intino.sumus.engine.model.DimensionDefinition;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DimensionDefinitionDeserializer
implements JsonDeserializer<DimensionDefinition> {
    static final String Diacrit = "~";
    static final String OpenBracket = "[";
    static final String CloseBracket = "]";
    private final Map<String, AttributeDefinition> attributes;

    public DimensionDefinitionDeserializer(Map<String, AttributeDefinition> attributes) {
        this.attributes = attributes;
    }

    public DimensionDefinition deserialize(JsonElement jsonElement, Type deserializerType, JsonDeserializationContext c) throws JsonParseException {
        JsonObject object = jsonElement.getAsJsonObject();
        String type = (String)c.deserialize(object.get("type"), String.class);
        DimensionDefinition.Type dimensionType = DimensionDefinition.Type.valueOf(type);
        return this.definition(dimensionType, object, c);
    }

    private DimensionDefinition definition(DimensionDefinition.Type type, JsonObject object, JsonDeserializationContext c) {
        AttributeDefinition attribute = this.attribute(object, c);
        String name = (String)c.deserialize(object.get("name"), String.class);
        Map categoryValue = (Map)c.deserialize(object.get("categoryValue"), Map.class);
        return type == DimensionDefinition.Type.Numerical ? new DimensionDefinition.Numerical(name, attribute, this.numericalCategories(attribute, categoryValue)) : new DimensionDefinition.Categorical(name, attribute, this.categoricalCategories(categoryValue));
    }

    private Map<String, Predicate<?>> categoricalCategories(Map<String, String> categoryValue) {
        LinkedHashMap categories = new LinkedHashMap();
        categoryValue.forEach((label, regex) -> categories.put((String)label, Pattern.compile(regex).asMatchPredicate()));
        return categories;
    }

    private Map<String, Predicate<?>> numericalCategories(AttributeDefinition attribute, Map<String, String> categoryValue) {
        LinkedHashMap categories = new LinkedHashMap();
        categoryValue.forEach((label, range) -> {
            Matcher matcher = DimensionDefinitionDeserializer.rangePattern(range);
            if (!matcher.matches()) {
                throw new JsonParseException("Numerical dimension slice not well formatted. Pattern didn't match. " + range);
            }
            categories.put((String)label, this.numericalSlicePredicate(matcher, (String)range, attribute));
        });
        return categories;
    }

    private Predicate<?> numericalSlicePredicate(Matcher matcher, String range, AttributeDefinition attribute) throws JsonParseException {
        if (range.startsWith(OpenBracket) || matcher.group(2).equals(Diacrit)) {
            return this.leftClosedPredicate(attribute, DimensionDefinitionDeserializer.parse(matcher.group(2)), DimensionDefinitionDeserializer.parse(matcher.group(5)));
        }
        if (range.endsWith(CloseBracket) || matcher.group(5).equals(Diacrit)) {
            return this.rightClosedPredicate(attribute, DimensionDefinitionDeserializer.parse(matcher.group(0)), DimensionDefinitionDeserializer.parse(matcher.group(1)));
        }
        throw new JsonParseException("Numerical dimension slice not well formatted. Missing closed interval. " + range);
    }

    private Predicate<?> leftClosedPredicate(AttributeDefinition attr, Long left, Long right) {
        return attr.isReal() ? this.doublePredicate(v -> Objects.isNull(left) || DimensionDefinitionDeserializer.toDouble(v) >= (double)left.longValue(), v -> Objects.isNull(right) || DimensionDefinitionDeserializer.toDouble(v) < (double)right.longValue()) : this.longPredicate(v -> Objects.isNull(left) || DimensionDefinitionDeserializer.toLong(v) >= left, v -> Objects.isNull(right) || DimensionDefinitionDeserializer.toLong(v) < right);
    }

    private Predicate<?> rightClosedPredicate(AttributeDefinition attr, Long left, Long right) {
        return attr.isReal() ? this.doublePredicate(v -> Objects.isNull(left) || DimensionDefinitionDeserializer.toDouble(v) > (double)left.longValue(), v -> Objects.isNull(right) || DimensionDefinitionDeserializer.toDouble(v) <= (double)right.longValue()) : this.longPredicate(v -> Objects.isNull(left) || DimensionDefinitionDeserializer.toLong(v) > left, v -> Objects.isNull(right) || DimensionDefinitionDeserializer.toLong(v) <= right);
    }

    private Predicate<Object> longPredicate(Predicate<Object> left, Predicate<Object> right) {
        return v -> !Objects.isNull(v) && left.test(DimensionDefinitionDeserializer.toLong(v)) && right.test(DimensionDefinitionDeserializer.toLong(v));
    }

    private Predicate<Object> doublePredicate(Predicate<Object> left, Predicate<Object> right) {
        return v -> !Objects.isNull(v) && left.test(DimensionDefinitionDeserializer.toDouble(v)) && right.test(DimensionDefinitionDeserializer.toDouble(v));
    }

    private static long toLong(Object v) {
        return ((Number)v).longValue();
    }

    private static double toDouble(Object v) {
        return ((Number)v).doubleValue();
    }

    private static Long parse(String s) {
        try {
            if (s == null) {
                return null;
            }
            return Long.parseLong(s.trim());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Matcher rangePattern(String range) {
        String patternStr = "([\\[(])((\\d+)|~),\\s?((\\d+)|~)(]|\\))";
        Pattern pattern = Pattern.compile(patternStr);
        return pattern.matcher(range);
    }

    private AttributeDefinition attribute(JsonObject object, JsonDeserializationContext c) {
        AttributeDefinition attribute = (AttributeDefinition)c.deserialize(object.get("attribute"), AttributeDefinition.class);
        return attribute != null ? this.attributes.get(attribute.name()) : null;
    }
}

