/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.builders.accumulators;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.builders.accumulators.BuilderAccumulator;
import java.util.Arrays;
import java.util.List;

public class DoubleAccumulator
extends BuilderAccumulator {
    private final int[] count;
    private final double[] sum;
    private final double[] totalSum;
    private final double[] min;
    private final double[] max;

    public DoubleAccumulator(String name) {
        super(name);
        this.count = new int[this.threadCount];
        this.sum = new double[this.threadCount];
        this.totalSum = new double[this.threadCount];
        this.min = new double[this.threadCount];
        this.max = new double[this.threadCount];
        Arrays.fill(this.min, Double.MAX_VALUE);
        Arrays.fill(this.max, Double.MIN_VALUE);
    }

    @Override
    public void addTotal(Object value) {
        int t;
        int n = t = this.threadIndex();
        this.total[n] = this.total[n] + 1;
        if (value != null) {
            int n2 = t;
            this.totalSum[n2] = this.totalSum[n2] + (Double)value;
        }
    }

    @Override
    public void add(Object value) {
        if (value == null) {
            return;
        }
        int t = this.threadIndex();
        double v = (Double)value;
        int n = t;
        this.count[n] = this.count[n] + 1;
        int n2 = t;
        this.sum[n2] = this.sum[n2] + v;
        this.min[t] = Math.min(this.min[t], v);
        this.max[t] = Math.max(this.max[t], v);
    }

    @Override
    public List<Cube.Indicator> indicators() {
        int count = this.count();
        double totalSum = this.totalSum();
        double sum = this.sum();
        double min = this.min();
        double max = this.max();
        return List.of(Cube.indicator("count(" + this.name + ")", count), Cube.indicator("ratio(" + this.name + ")", totalSum > 0.0 ? sum / totalSum : 0.0), Cube.indicator("sum(" + this.name + ")", sum), Cube.indicator("average(" + this.name + ")", count > 0 ? sum / (double)count : 0.0), Cube.indicator("min(" + this.name + ")", min), Cube.indicator("max(" + this.name + ")", max));
    }

    public double max() {
        return Arrays.stream(this.max).max().orElse(Double.MIN_VALUE);
    }

    public double min() {
        return Arrays.stream(this.min).min().orElse(Double.MAX_VALUE);
    }

    public double sum() {
        return Arrays.stream(this.sum).sum();
    }

    public double totalSum() {
        return Arrays.stream(this.totalSum).sum();
    }

    public int count() {
        return Arrays.stream(this.count).sum();
    }
}

