/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.builders;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.intino.sumus.engine.builders.adapters.LedgerDefinitionAdapter;
import io.intino.sumus.engine.builders.deserializers.AggregationDeserializer;
import io.intino.sumus.engine.builders.deserializers.AttributeDefinitionDeserializer;
import io.intino.sumus.engine.builders.deserializers.LedgerDefinitionDeserializer;
import io.intino.sumus.engine.builders.deserializers.ScaleDeserializer;
import io.intino.sumus.engine.helpers.Json;
import io.intino.sumus.engine.model.AttributeDefinition;
import io.intino.sumus.engine.model.IndicatorDefinition;
import io.intino.sumus.engine.model.LedgerDefinition;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.text.ParseException;

public class LedgerDefinitionBuilder {
    private static final Gson Gson = new GsonBuilder().registerTypeAdapter(LedgerDefinition.class, (Object)new LedgerDefinitionDeserializer()).registerTypeAdapter(LedgerDefinition.Aggregation.class, (Object)new AggregationDeserializer()).registerTypeAdapter(AttributeDefinition.class, (Object)new AttributeDefinitionDeserializer()).registerTypeAdapter(IndicatorDefinition.Scale.class, (Object)new ScaleDeserializer()).create();
    private final File baseDirectory;

    public LedgerDefinitionBuilder(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public LedgerDefinition build(File file) throws ParseException {
        try {
            return this.build(Files.readString(file.toPath(), Charset.defaultCharset()));
        }
        catch (IOException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    public LedgerDefinition build(String definition) throws ParseException {
        return Json.isJson(definition) ? LedgerDefinitionBuilder.parseJson(definition) : this.parseLegacyLang(definition);
    }

    private LedgerDefinition parseLegacyLang(String definition) throws ParseException {
        io.intino.sumus.model.LedgerDefinition oldDefinition = new io.intino.sumus.LedgerDefinitionBuilder(this.baseDirectory).build(definition);
        return LedgerDefinitionAdapter.adapt(oldDefinition);
    }

    private static LedgerDefinition parseJson(String definition) {
        return (LedgerDefinition)Gson.fromJson(definition, LedgerDefinition.class);
    }
}

