package io.intino.sumus.engine.model;


public class CompositeIndicatorDefinition extends IndicatorDefinition {

    private final String formula;

    public CompositeIndicatorDefinition(String name, String formula, String unit, Scale scale, Integer decimals) {
        super(Type.Composite, name, unit, scale, decimals);
        this.formula = formula;
    }

    public String formula() {
        return formula;
    }

    public String label() {
        return "calculate(" + formula + ")";
    }
}
