package io.intino.sumus.engine.helpers;

import com.google.gson.*;

public class Json {

    public static String toJson(Object obj) {
        return new Gson().toJson(obj);
    }

    public static String toJsonPretty(Object obj) {
        return new GsonBuilder().setPrettyPrinting().create().toJson(obj);
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        return new Gson().fromJson(json, clazz);
    }

    public static boolean isJson(String text) {
        try {
            JsonElement jsonElement = JsonParser.parseString(text);
            return jsonElement.isJsonObject() || jsonElement.isJsonArray();
        } catch (JsonSyntaxException e) {
            return false;
        }
    }
}
