package io.intino.sumus.engine.builders.evaluators;


import io.intino.sumus.engine.Cube.Indicator;
import io.intino.sumus.engine.model.CompositeIndicatorDefinition;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class CompositeEvaluator {

    static final String TextRegex = ".*[a-zA-Z_].*";

    public static Double evaluate(CompositeIndicatorDefinition composite, List<Indicator> indicators) {
        try {
            String expression = expressionOf(composite.formula(), indicators);
            return ExpressionEvaluator.evaluate(expression);
        } catch (Throwable e) {
            return null;
        }
    }

    private static String expressionOf(String formula, List<Indicator> indicators) throws IllegalArgumentException {
        //Sort by indicator name length to prevent wrong substitution when indicator names are similar
        List<Indicator> sorted = indicators.stream()
                .filter(Objects::nonNull)
                .filter(i -> formula.contains(i.name()))
                .sorted((i1, i2) -> Integer.compare(i2.name().length(), i1.name().length()))
                .collect(Collectors.toList());

        String expression = formula;
        for (Indicator i : sorted) {
            Double value = toDouble(i.value());
            if (value == null) continue;
            expression = expression.replace(i.name(), new BigDecimal(value).toPlainString());
        }
        if (expression.matches(TextRegex))
            throw new IllegalArgumentException("Invalid formula: indicators not found");

        return expression;
    }

    private static Double toDouble(Object value) {
        try {
            return Double.parseDouble(value.toString());
        } catch (Throwable e) {
            return null;
        }
    }
}
