package io.intino.sumus.engine.builders.deserializers;

import com.google.gson.*;
import io.intino.sumus.engine.model.IndicatorDefinition;

import java.lang.reflect.Type;

public class ScaleDeserializer implements JsonDeserializer<IndicatorDefinition.Scale> {

    @Override
    public IndicatorDefinition.Scale deserialize(JsonElement jsonElement, Type deserializerType, JsonDeserializationContext c) throws JsonParseException {
        JsonObject object = jsonElement.getAsJsonObject();
        Double from = c.deserialize(object.get("from"), Double.class);
        Double to = c.deserialize(object.get("to"), Double.class);
        return new IndicatorDefinition.Scale(from, to);
    }
}
