package io.intino.sumus.engine.builders.deserializers;

import com.google.gson.*;
import io.intino.sumus.engine.model.AttributeDefinition;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AttributeDefinitionDeserializer implements JsonDeserializer<AttributeDefinition> {

    @Override
    public AttributeDefinition deserialize(JsonElement jsonElement, Type deserializerType, JsonDeserializationContext c) throws JsonParseException {
        JsonObject object = jsonElement.getAsJsonObject();
        String type = c.deserialize(object.get("type"), String.class);
        String name = c.deserialize(object.get("name"), String.class);
        return AttributeDefinition.create(type, name, parameters(object, c));
    }

    private static String[] parameters(JsonObject object, JsonDeserializationContext c) {
        List<String> parameters = new ArrayList<>();
        parameters.add(c.deserialize(object.get("ledgerJoin"), String.class));
        parameters.add(c.deserialize(object.get("path"), String.class));
        return parameters.stream().filter(Objects::nonNull).toArray(String[]::new);
    }
}
