package io.intino.sumus.engine.builders.deserializers;

import com.google.gson.*;
import io.intino.sumus.engine.model.LedgerDefinition.Aggregation;

import java.lang.reflect.Type;

public class AggregationDeserializer implements JsonDeserializer<Aggregation> {

    @Override
    public Aggregation deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext c) throws JsonParseException {
        JsonObject object = jsonElement.getAsJsonObject();
        Aggregation.Period period = c.deserialize(object.get("period"), Aggregation.Period.class);
        String ledger = c.deserialize(object.get("ledger"), String.class);
        String recordKey = c.deserialize(object.get("recordKey"), String.class);
        String from = c.deserialize(object.get("from"), String.class);
        return new Aggregation(period, ledger, recordKey, from);
    }
}
