package io.intino.sumus.engine.builders.adapters;

import io.intino.sumus.engine.model.AttributeDefinition;
import io.intino.sumus.engine.model.LedgerDefinition;
import io.intino.sumus.engine.model.LedgerDefinition.Aggregation;
import io.intino.sumus.engine.model.LedgerDefinition.Content;
import io.intino.sumus.engine.model.LedgerDefinition.Format;

import java.util.List;

public class LedgerDefinitionAdapter {

    public static LedgerDefinition adapt(io.intino.sumus.model.LedgerDefinition old) {
        LedgerDefinition newDefinition = new LedgerDefinition(
                content(old.content),
                format(old.format),
                aggregation(old.aggregation),
                old.label,
                old.description
        );
        List<AttributeDefinition> attributes = AttributeDefinitionAdapter.adapt(old.attributes);

        attributes.forEach(newDefinition::add);
        IndicatorDefinitionAdapter.adapt(old.indicators, attributes).forEach(newDefinition::add);
        DimensionDefinitionAdapter.adapt(old.dimensions, attributes).forEach(newDefinition::add);
        return newDefinition;
    }

    private static Aggregation aggregation(io.intino.sumus.model.LedgerDefinition.Aggregation old) {
        return old != null ? new Aggregation(period(old.period), old.ledger, old.recordKey, old.from) : null;
    }

    private static Content content(io.intino.sumus.model.LedgerDefinition.Content old) {
        try {
            return Content.valueOf(old.name());
        } catch (Throwable e) {
            return null;
        }
    }

    private static Format format(io.intino.sumus.model.LedgerDefinition.Format old) {
        try {
            return Format.valueOf(old.name());
        } catch (Throwable e) {
            return null;
        }
    }

    private static Aggregation.Period period(io.intino.sumus.model.LedgerDefinition.Aggregation.Period old) {
        try {
            return Aggregation.Period.valueOf(old.name());
        } catch (Throwable e) {
            return null;
        }
    }
}
