package io.intino.sumus.engine.builders.adapters;

import io.intino.sumus.engine.model.AttributeDefinition;
import io.intino.sumus.engine.model.CompositeIndicatorDefinition;
import io.intino.sumus.engine.model.IndicatorDefinition;
import io.intino.sumus.engine.model.SimpleIndicatorDefinition;

import java.util.List;

public class IndicatorDefinitionAdapter {

    public static List<IndicatorDefinition> adapt(List<io.intino.sumus.model.IndicatorDefinition> oldIndicators, List<AttributeDefinition> attributes) {
        return oldIndicators.stream().map(i -> adapt(i, attributes)).toList();
    }

    public static IndicatorDefinition adapt(io.intino.sumus.model.IndicatorDefinition old, List<AttributeDefinition> attributes) {
        return old.isComposite() ? simple(old.asComposite()) : composite(old.asSimple(), attributes);
    }

    public static SimpleIndicatorDefinition composite(io.intino.sumus.model.SimpleIndicatorDefinition old, List<AttributeDefinition> attributes) {
        return new SimpleIndicatorDefinition(
                old.name(),
                function(old.function()),
                attributeOf(old, attributes),
                old.unit(),
                scale(old.scale()),
                old.filteredValues(),
                old.decimals()
        );
    }

    private static AttributeDefinition attributeOf(io.intino.sumus.model.SimpleIndicatorDefinition old, List<AttributeDefinition> attributes) {
        return attributes.stream().filter(a -> a.name().equalsIgnoreCase(old.attribute().name())).findFirst().orElse(null);
    }

    public static CompositeIndicatorDefinition simple(io.intino.sumus.model.CompositeIndicatorDefinition old) {
        return new CompositeIndicatorDefinition(
                old.name(),
                old.formula(),
                old.unit(),
                scale(old.scale()),
                old.decimals()
        );
    }

    private static IndicatorDefinition.Scale scale(io.intino.sumus.model.IndicatorDefinition.Scale scale) {
        return scale != null ? new IndicatorDefinition.Scale(scale.from(), scale.to()) : null;
    }

    private static SimpleIndicatorDefinition.Function function(io.intino.sumus.model.SimpleIndicatorDefinition.Function old) {
        try {
            return SimpleIndicatorDefinition.Function.valueOf(old.name());
        } catch (Throwable e) {
            return null;
        }
    }
}
