package io.intino.sumus.engine.builders.adapters;

import io.intino.sumus.engine.model.AttributeDefinition;
import io.intino.sumus.engine.model.DimensionDefinition;
import io.intino.sumus.engine.model.DimensionDefinition.Categorical;
import io.intino.sumus.engine.model.DimensionDefinition.Numerical;

import java.util.List;

public class DimensionDefinitionAdapter {

    public static List<DimensionDefinition> adapt(List<io.intino.sumus.model.DimensionDefinition> dimensions, List<AttributeDefinition> attributes) {
        return dimensions.stream().map(d -> adapt(d , attributes)).toList();
    }

    private static DimensionDefinition adapt(io.intino.sumus.model.DimensionDefinition old, List<AttributeDefinition> attributes) {
        AttributeDefinition attribute = attributeOf(old, attributes);
        return old.isNumeric() ?
                new Numerical(old.name(), attribute, old.categories()) :
                new Categorical(old.name(), attribute, old.categories());
    }

    private static AttributeDefinition attributeOf(io.intino.sumus.model.DimensionDefinition old, List<AttributeDefinition> attributes) {
        return attributes.stream().filter(a -> a.name().equalsIgnoreCase(old.attribute().name())).findFirst().orElse(null);
    }
}
