package io.intino.sumus.engine.builders.adapters;

import io.intino.sumus.engine.model.AttributeDefinition;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AttributeDefinitionAdapter {

    public static List<AttributeDefinition> adapt(List<io.intino.sumus.model.AttributeDefinition> oldAttributes) {
        return oldAttributes.stream().map(AttributeDefinitionAdapter::adapt).filter(Objects::nonNull).toList();
    }

    private static AttributeDefinition adapt(io.intino.sumus.model.AttributeDefinition old) {
        return old.type() != null ? AttributeDefinition.create(old.type().name(), old.name(), parameters(old)) : null;
    }

    private static String[] parameters(io.intino.sumus.model.AttributeDefinition old) {
        List<String> parameters = new ArrayList<>();
        if (old instanceof io.intino.sumus.model.AttributeDefinition.Key)
            parameters.add(((io.intino.sumus.model.AttributeDefinition.Key) old).ledgerJoin());
        if (old instanceof io.intino.sumus.model.AttributeDefinition.Url)
            parameters.add(((io.intino.sumus.model.AttributeDefinition.Url) old).path());
        return parameters.toArray(String[]::new);
    }
}
