package io.intino.sumus.engine;

import io.intino.sumus.engine.filters.SliceFilter;
import io.intino.sumus.engine.helpers.Finder;
import io.intino.sumus.engine.ledgers.columnar.Column;
import io.intino.sumus.engine.model.LedgerDefinition;

import java.util.*;

import static java.util.Arrays.asList;

public interface Ledger {
	LedgerDefinition definition();
	int size();
	List<Attribute> attributes();
	default Attribute attribute(String name) { return new Finder<>(attributes()).find(name); }
	List<Dimension> dimensions();
	default Dimension dimension(String name) { return new Finder<>(dimensions()).find(name); }
	default Slice slice(String slice) {
		String[] split = slice.split(":");
		return slice(split[0], split[1]);
	}
	default Slice slice(String dimension, String slice) {
		return dimension(dimension).slice(slice);
	}
	default Iterable<Fact> facts() {return facts(Filter.None); }
	Iterable<Fact> facts(Filter filter);
	List<Column> columns(String name);

	Query cube();

	interface Query {
		Query filter(Filter filter);
		default Query filter(Slice... slices) { return filter(SliceFilter.of(slices)); }
		Query dimensions(List<Dimension> dimensions);
		default Query dimensions(Dimension... dimensions) { return dimensions(asList(dimensions)); }

		Cube build();
	}

}
