package io.intino.sumus.engine;

import io.intino.sumus.engine.model.AttributeDefinition;
import io.intino.sumus.engine.model.DimensionDefinition;

// Move to interface
// Create ColumnarAttribute
public interface Attribute {
	Attribute Null = new NullAttribute();

	AttributeDefinition definition();

	boolean isUsedInIndicators();

	DimensionDefinition[] dimensions();

	default String name() {
		return definition().name();
	}

	default boolean isNumeric() {
		return definition().isNumeric();
	}

	default AttributeDefinition.Type type() {
		return definition().type();
	}

	class NullAttribute implements Attribute {

		@Override
		public AttributeDefinition definition() {
			return new AttributeDefinition.Label("");
		}

		@Override
		public boolean isUsedInIndicators() {
			return false;
		}

		@Override
		public DimensionDefinition[] dimensions() {
			return new DimensionDefinition[0];
		}
	}
}
