package io.intino.sumus.engine.concurrency;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class SumusThreadFactory implements ThreadFactory {

	private final String group;
	private final AtomicInteger index = new AtomicInteger(0);

	public SumusThreadFactory(String group) {
		this.group = group;
	}

	@Override
	public synchronized Thread newThread(Runnable r) {
		int index = this.index.getAndIncrement();
		return new SumusThread(r, group + String.format("%02d", index), index);
	}

	public static final class SumusThread extends Thread {

		public final int index;

		public SumusThread(Runnable target, String name, int index) {
			super(target, name);
			this.index = index;
		}
	}
}
