/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.builders.accumulators;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.builders.accumulators.BuilderAccumulator;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.List;

public class TimeAccumulator
extends BuilderAccumulator {
    private final int[] count;
    private final int[] min;
    private final int[] max;

    public TimeAccumulator(String name) {
        super(name);
        this.count = new int[this.threadCount];
        this.min = new int[this.threadCount];
        this.max = new int[this.threadCount];
        Arrays.fill(this.min, Integer.MAX_VALUE);
        Arrays.fill(this.max, Integer.MIN_VALUE);
    }

    @Override
    public void add(Object value) {
        int t;
        if (value == null) {
            return;
        }
        int n = t = this.threadIndex();
        this.count[n] = this.count[n] + 1;
        this.min[t] = Math.min(this.min[t], (Integer)value);
        this.max[t] = Math.max(this.max[t], (Integer)value);
    }

    @Override
    public List<Cube.Indicator> indicators() {
        int count = this.count();
        int min = this.min();
        int max = this.max();
        return List.of(Cube.indicator("count(" + this.name + ")", count), Cube.indicator("min(" + this.name + ")", this.minTime(min)), Cube.indicator("max(" + this.name + ")", this.maxTime(max)));
    }

    public int max() {
        return Arrays.stream(this.max).max().orElse(Integer.MIN_VALUE);
    }

    public int min() {
        return Arrays.stream(this.min).min().orElse(Integer.MAX_VALUE);
    }

    public int count() {
        return Arrays.stream(this.count).sum();
    }

    private LocalTime minTime(int min) {
        return min == Integer.MAX_VALUE ? LocalTime.MAX : LocalTime.ofSecondOfDay(min);
    }

    private LocalTime maxTime(int max) {
        return max == Integer.MIN_VALUE ? LocalTime.MIN : LocalTime.ofSecondOfDay(max);
    }
}

