/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.builders.accumulators;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.builders.accumulators.BuilderAccumulator;
import io.intino.sumus.engine.dimensions.Category;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CountAccumulator
extends BuilderAccumulator {
    private final CountMap[] counts;

    public CountAccumulator(String name) {
        super(name);
        this.counts = new CountMap[this.threadCount];
        for (int i = 0; i < this.counts.length; ++i) {
            this.counts[i] = new CountMap();
        }
    }

    @Override
    public void add(Object value) {
        int t = this.threadIndex();
        this.increment(t, "");
        if (value instanceof Category) {
            this.increment(t, ((Category)value).label);
        }
    }

    private void increment(int t, String key) {
        CountMap counts = this.counts[t];
        counts.put(key, counts.getOrDefault(key, 0) + 1);
    }

    @Override
    public List<Cube.Indicator> indicators() {
        Map<String, Integer> counts = this.countsMap();
        long total = this.total();
        return counts.entrySet().stream().map(e -> this.indicatorsOf(this.segmentOf((String)e.getKey()), (Integer)e.getValue(), total)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Map<String, Integer> countsMap() {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (CountMap c : this.counts) {
            c.forEach((k, v) -> counts.compute((String)k, (kk, vv) -> vv == null ? v : vv + v));
        }
        return counts;
    }

    private String segmentOf(String key) {
        return key.isEmpty() ? "" : " with " + key;
    }

    private List<Cube.Indicator> indicatorsOf(String segment, int count, long total) {
        return List.of(Cube.indicator("count(" + this.name + ")" + segment, count), Cube.indicator("ratio(" + this.name + ")" + segment, (double)count / (double)total));
    }

    public int total() {
        return Arrays.stream(this.total).sum();
    }

    private static class CountMap
    extends HashMap<String, Integer> {
        public CountMap() {
            super(1024);
        }
    }
}

