package io.intino.sumus.engine.ledgers.composite;

import io.intino.sumus.engine.Dimension;
import io.intino.sumus.engine.Index;
import io.intino.sumus.engine.Slice;

import java.util.List;
import java.util.Objects;

import static java.util.stream.Collectors.toList;

public class CompositeSlice implements Slice {
	private final Slice prototype;
	private final List<Slice> slices;
	private final int[] offsets;
	private final Slice parent;
	private Index index;

	public CompositeSlice(List<Slice> slices, int[] offsets, Slice parent) {
		this.prototype = slices.stream().filter(Objects::nonNull).findFirst().orElse(null);
		this.slices = slices;
		this.offsets = offsets;
		this.index = null;
		this.parent = parent;
	}

	@Override
	public String name() {
		return prototype.name();
	}


	@Override
	public Slice parent() {
		return parent;
	}

	@Override
	public Dimension dimension() {
		return prototype.dimension();
	}


	@Override
	public boolean isNA() {
		for (Slice slice : slices)
			if (slice != null && slice.isNA()) return true;
		return false;
	}

	@Override
	public Index index() {
		if (index == null) index = new CompositeIndex(indexes(), offsets);
		return index;
	}

	private List<Index> indexes() {
		return slices.stream().map(s-> s != null ? s.index() : Index.None).collect(toList());
	}

	@Override
	public String toString() {
		return name();
	}
}
