package io.intino.sumus.engine.filters;

import io.intino.sumus.engine.Filter;
import io.intino.sumus.engine.Ledger;
import io.intino.sumus.engine.ledgers.columnar.Column;

import java.time.LocalDate;
import java.util.List;

public class DateFilter implements Filter {

    private final List<Column> columns;
    private final long from;
    private final long to;

    public DateFilter(Ledger ledger, String columnName, LocalDate from, LocalDate to) {
        this.columns = ledger.columns(columnName);
        this.from = from.toEpochDay();
        this.to = to.toEpochDay();
    }

    @Override
    public boolean accepts(int idx) {
        int offset = 0;
        for(Column column : columns) {
            if(idx < column.size()) {
                Object value = column.value(idx - offset);
                if (!(value instanceof Long)) return false;
                long v = (long) value;
                return from <= v && v < to;
            }
            offset += column.size();
        }
        return false;
    }

    public static class FromDateFilter extends DateFilter {
        public FromDateFilter(Ledger ledger, String columnName, LocalDate from) {
            super(ledger, columnName, from, LocalDate.MAX);
        }
    }

    public static class ToDateFilter extends DateFilter {
        public ToDateFilter(Ledger ledger, String columnName, LocalDate to) {
            super(ledger, columnName, LocalDate.MIN, to);
        }
    }
}
