package io.intino.sumus.engine.builders.accumulators;

import io.intino.sumus.engine.SumusEngine;
import io.intino.sumus.engine.builders.Accumulator;
import io.intino.sumus.engine.concurrency.SumusThreadFactory;

public abstract class BuilderAccumulator implements Accumulator {

	public final String name;
	protected final int threadCount = SumusEngine.threadCount();
	protected final int[] total = new int[threadCount];

	public BuilderAccumulator(String name) {
		this.name = name;
	}

	@Override
	public String name() {
		return name;
	}

	@Override
	public void addTotal(Object value) {
		this.total[threadIndex()]++;
	}

	protected final int threadIndex() {
		return ((SumusThreadFactory.SumusThread)Thread.currentThread()).index;
	}
}
