package io.intino.sumus.engine;

import io.intino.sumus.engine.concurrency.SumusThreadFactory;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class SumusEngine {

	public static final AtomicLong TIMEOUT_AMOUNT = new AtomicLong(40);
	public static final AtomicReference<TimeUnit> TIMEOUT_UNIT = new AtomicReference<>(TimeUnit.SECONDS);

	private static final AtomicInteger ThreadCount = new AtomicInteger(Math.max(Runtime.getRuntime().availableProcessors() - 1, 1));

	public static int threadCount() {
		return ThreadCount.get();
	}

	public static synchronized void setThreadCount(int threadCount) {
		ThreadCount.set(Math.max(Math.min(threadCount, Runtime.getRuntime().availableProcessors()), 1));
	}

	public static ExecutorService createThreadPool() {
		return Executors.newFixedThreadPool(ThreadCount.get(), new SumusThreadFactory("CubeBuilder-T"));
	}
}
