package io.intino.sumus.engine;

import io.intino.sumus.model.AttributeDefinition;
import io.intino.sumus.model.DimensionDefinition;
import io.intino.sumus.model.LedgerDefinition;

import java.util.Objects;

public abstract class AbstractAttribute implements Attribute {

    protected final AttributeDefinition definition;

    public AbstractAttribute(AttributeDefinition definition) {
        this.definition = definition;
    }

    @Override
    public AttributeDefinition definition() {
        return definition;
    }

    protected abstract LedgerDefinition ledgerDefinition();

    @Override
    public boolean isUsedInIndicators() {
        return ledgerDefinition().indicators.stream()
                .anyMatch(i -> i.attribute().equals(definition));
    }

    @Override
    public DimensionDefinition[] dimensions() {
        return ledgerDefinition().dimensions.stream()
                .filter(d -> d.attribute().equals(definition))
                .toArray(DimensionDefinition[]::new);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || getClass() != o.getClass()) return false;
        return this == o || areEquals((Attribute) o);
    }

    private boolean areEquals(Attribute attribute) {
        return Objects.equals(name(), attribute.name()) && type().equals(attribute.type());
    }

    @Override
    public int hashCode() {
        return Objects.hash(name(), type());
    }

    @Override
    public String toString() {
        return name();
    }
}
