/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.ledgers.composite;

import io.intino.sumus.engine.Dimension;
import io.intino.sumus.engine.Slice;
import io.intino.sumus.engine.helpers.IgnoreCaseMap;
import io.intino.sumus.engine.ledgers.composite.CompositeSlice;
import io.intino.sumus.model.AttributeDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class CompositeDimension
implements Dimension {
    private final List<Dimension> dimensions;
    private final List<Slice> slices;
    private final int[] offsets;

    public CompositeDimension(List<Dimension> dimensions, int[] offsets) {
        this.dimensions = dimensions;
        this.slices = new ArrayList<Slice>();
        this.offsets = offsets;
    }

    @Override
    public String name() {
        return this.dimensions.get(0).name();
    }

    @Override
    public AttributeDefinition.Type type() {
        return this.dimensions.get(0).type();
    }

    @Override
    public boolean hasNA() {
        for (Dimension dimension : this.dimensions) {
            if (!dimension.hasNA()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Slice> slices() {
        if (this.slices.isEmpty()) {
            this.slices.addAll(this.buildSlices());
        }
        return this.slices;
    }

    @Override
    public boolean isOrdinal() {
        return false;
    }

    @Override
    public List<Slice> slices(int level) {
        return new ArrayList<Slice>(this.dimensions.stream().flatMap(d -> d.slices(level).stream()).collect(Collectors.toMap(Slice::name, s -> s, (a, b) -> b, IgnoreCaseMap::new)).values());
    }

    private List<Slice> buildSlices() {
        List<String> names = this.sliceNames();
        HashMap<String, CompositeSlice> slices = new HashMap<String, CompositeSlice>();
        for (String name : names) {
            slices.put(name, new CompositeSlice(this.find(name), this.offsets, (Slice)slices.get(this.parentOf(name))));
        }
        return names.stream().map(slices::get).collect(Collectors.toList());
    }

    private String parentOf(String name) {
        int i = name.lastIndexOf(46);
        return i > 0 && name.charAt(i - 1) != '.' ? name.substring(0, i) : null;
    }

    private List<Slice> find(String name) {
        return this.dimensions.stream().map(d -> this.find(name, (Dimension)d)).collect(Collectors.toList());
    }

    private Slice find(String name, Dimension dimension) {
        return dimension.slices().stream().filter(s -> s.name().equals(name)).findFirst().orElse(null);
    }

    private List<String> sliceNames() {
        return this.dimensions.stream().flatMap(d -> d.slices().stream()).map(Slice::name).distinct().collect(Collectors.toList());
    }

    public String toString() {
        return this.name();
    }
}

