/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.ledgers.columnar.columns;

import io.intino.sumus.engine.Attribute;
import io.intino.sumus.engine.dimensions.Category;
import io.intino.sumus.engine.ledgers.columnar.Column;
import io.intino.sumus.model.AttributeDefinition;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DataColumn
implements Column {
    public final Attribute attribute;
    public final List<Object> values;
    private final Map<String, Object> cache;
    private Object min;
    private Object max;
    private static final DateTimeFormatter DateFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final DateTimeFormatter TimeFormatter = DateTimeFormatter.ofPattern("HHmmss");

    public DataColumn(Attribute attribute, String ... values) {
        this.attribute = attribute;
        this.cache = new HashMap<String, Object>(values.length / 2);
        this.values = this.map(values, this.function(values));
    }

    private Comparator<Object> comparatorOf(AttributeDefinition.Type type) {
        switch (type) {
            case int8: 
            case int16: 
            case int32: 
            case int64: 
            case date: 
            case time: {
                return Comparator.comparingLong(a -> (Long)a);
            }
            case real32: 
            case real64: {
                return Comparator.comparingDouble(a -> (Double)a);
            }
        }
        return (a, b) -> 0;
    }

    private Function<String, Object> function(String[] values) {
        switch (this.attribute.type()) {
            case category: {
                return this.get(DataColumn.categoriesIn(values));
            }
            case int8: 
            case int16: 
            case int32: 
            case int64: {
                return s -> this.computeIfAbsent((String)s, Long::parseLong);
            }
            case real32: 
            case real64: {
                return s -> this.computeIfAbsent((String)s, Double::parseDouble);
            }
            case date: {
                return s -> this.computeIfAbsent((String)s, this::toEpoch);
            }
            case time: {
                return s -> this.computeIfAbsent((String)s, this::toSecondDay);
            }
        }
        return s -> s;
    }

    private Object computeIfAbsent(String value, Function<String, Object> function) {
        if (this.cache.containsKey(value)) {
            return this.cache.get(value);
        }
        Object result = function.apply(value);
        this.cache.put(value, result);
        return result;
    }

    private Function<String, Object> get(Map<String, Category> categories) {
        return categories::get;
    }

    private List<Object> map(String[] values, Function<String, Object> function) {
        return Arrays.stream(values).map(DataColumn::clean).map(v -> v.isEmpty() ? null : this.catching(() -> function.apply((String)v))).collect(Collectors.toList());
    }

    private static String clean(String v) {
        return v != null ? v.trim() : "";
    }

    private static Map<String, Category> categoriesIn(String[] values) {
        HashMap<String, Category> categories = new HashMap<String, Category>();
        for (String value : values) {
            DataColumn.update(categories, DataColumn.split(DataColumn.clean(value)));
        }
        return categories;
    }

    private static List<String> split(String value) {
        if (value.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        int i = value.indexOf(46);
        while (i > 0) {
            result.add(value.substring(0, i));
            i = value.indexOf(46, i + 1);
        }
        result.add(value);
        return result;
    }

    private static void update(Map<String, Category> categories, List<String> labels) {
        Category parent = null;
        for (String label : labels) {
            if (!categories.containsKey(label)) {
                categories.put(label, new Category(categories.size() + 1, label, parent));
            }
            parent = categories.get(label);
        }
    }

    private void setRange() {
        Comparator<Object> comparator = this.comparatorOf(this.attribute.type());
        for (Object value : this.values) {
            if (value == null) continue;
            if (this.min == null || comparator.compare(value, this.min) < 0) {
                this.min = value;
            }
            if (this.max != null && comparator.compare(value, this.max) <= 0) continue;
            this.max = value;
        }
    }

    @Override
    public String name() {
        return this.attribute.name();
    }

    @Override
    public AttributeDefinition.Type type() {
        return this.attribute.type();
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public Attribute attribute() {
        return this.attribute;
    }

    @Override
    public Object value(int idx) {
        return this.values.get(idx);
    }

    @Override
    public boolean hasNA() {
        for (Object value : this.values) {
            if (value != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Object> uniques() {
        return this.values.stream().distinct().filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Object min() {
        if (this.min == null) {
            this.setRange();
        }
        return this.min;
    }

    @Override
    public Object max() {
        if (this.max == null) {
            this.setRange();
        }
        return this.max;
    }

    private Object catching(Callable<Object> function) {
        try {
            return function.call();
        }
        catch (Exception e) {
            return null;
        }
    }

    private Object toEpoch(String value) {
        if (value == null) {
            return null;
        }
        return LocalDate.parse(DataColumn.trim(value), DateFormatter).toEpochDay();
    }

    private Object toSecondDay(String value) {
        if (value == null) {
            return null;
        }
        return LocalTime.parse(DataColumn.trim(value), TimeFormatter).toSecondOfDay();
    }

    private static String trim(String value) {
        return value.replaceAll("[-/: .]", "");
    }

    public String toString() {
        return this.type().name() + " " + this.name();
    }
}

