/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.builders.accumulators;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.builders.accumulators.BuilderAccumulator;
import java.time.LocalTime;
import java.util.List;

public class TimeAccumulator
extends BuilderAccumulator {
    private int count = 0;
    private int min = Integer.MAX_VALUE;
    private int max = Integer.MIN_VALUE;

    public TimeAccumulator(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Object value) {
        if (value == null) {
            return;
        }
        TimeAccumulator timeAccumulator = this;
        synchronized (timeAccumulator) {
            ++this.count;
            this.min = Math.min(this.min, (Integer)value);
            this.max = Math.max(this.max, (Integer)value);
        }
    }

    @Override
    public List<Cube.Indicator> indicators() {
        return List.of(Cube.indicator("count(" + this.name + ")", this.count), Cube.indicator("min(" + this.name + ")", this.minTime()), Cube.indicator("max(" + this.name + ")", this.maxTime()));
    }

    private LocalTime minTime() {
        return this.min == Integer.MAX_VALUE ? LocalTime.MAX : LocalTime.ofSecondOfDay(this.min);
    }

    private LocalTime maxTime() {
        return this.max == Integer.MIN_VALUE ? LocalTime.MIN : LocalTime.ofSecondOfDay(this.max);
    }
}

