/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.builders.accumulators;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.builders.accumulators.BuilderAccumulator;
import java.time.LocalDate;
import java.util.List;

public class DateAccumulator
extends BuilderAccumulator {
    private int count = 0;
    private long min = Long.MAX_VALUE;
    private long max = Long.MIN_VALUE;

    public DateAccumulator(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Object value) {
        if (value == null) {
            return;
        }
        DateAccumulator dateAccumulator = this;
        synchronized (dateAccumulator) {
            ++this.count;
            this.min = Math.min(this.min, (Long)value);
            this.max = Math.max(this.max, (Long)value);
        }
    }

    @Override
    public List<Cube.Indicator> indicators() {
        return List.of(Cube.indicator("count(" + this.name + ")", this.count), Cube.indicator("min(" + this.name + ")", this.minDate()), Cube.indicator("max(" + this.name + ")", this.maxDate()));
    }

    private LocalDate minDate() {
        return this.min == Long.MAX_VALUE ? LocalDate.MAX : LocalDate.ofEpochDay(this.min);
    }

    private LocalDate maxDate() {
        return this.max == Long.MIN_VALUE ? LocalDate.MIN : LocalDate.ofEpochDay(this.max);
    }
}

