/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.builders.accumulators;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.builders.accumulators.BuilderAccumulator;
import io.intino.sumus.engine.dimensions.Category;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CountAccumulator
extends BuilderAccumulator {
    private final Map<String, Integer> counts = new HashMap<String, Integer>();

    public CountAccumulator(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Object value) {
        CountAccumulator countAccumulator = this;
        synchronized (countAccumulator) {
            this.increment("");
            if (value instanceof Category) {
                this.increment(((Category)value).label);
            }
        }
    }

    private void increment(String key) {
        this.counts.put(key, this.counts.getOrDefault(key, 0) + 1);
    }

    @Override
    public List<Cube.Indicator> indicators() {
        return this.counts.entrySet().stream().map(e -> this.indicatorsOf(this.segmentOf((String)e.getKey()), (Integer)e.getValue())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private String segmentOf(String key) {
        return key.isEmpty() ? "" : " with " + key;
    }

    private List<Cube.Indicator> indicatorsOf(String segment, int count) {
        return List.of(Cube.indicator("count(" + this.name + ")" + segment, count), Cube.indicator("ratio(" + this.name + ")" + segment, (double)count / (double)this.total));
    }
}

