package io.intino.sumus.engine.ledgers.columnar;

import io.intino.sumus.engine.Attribute;
import io.intino.sumus.engine.Index;
import io.intino.sumus.engine.Lookup;
import io.intino.sumus.engine.ledgers.columnar.columns.NullColumn;

import java.util.function.Predicate;

public interface Column extends Lookup {

	Column Null = new NullColumn();

	int size();

	Attribute attribute();

	Object value(int idx);

	@Override
	default Index createIndex(Predicate<Object> predicate) {
		return idx -> predicate.test(value(idx));
	}
}
