package io.intino.sumus.engine.builders.accumulators;

import io.intino.sumus.engine.Cube;

import java.time.LocalTime;
import java.util.List;

import static io.intino.sumus.engine.Cube.indicator;

public class TimeAccumulator extends BuilderAccumulator {
	private int count;
	private int min;
	private int max;

	public TimeAccumulator(String name) {
		super(name);
		this.count = 0;
		this.min = Integer.MAX_VALUE;
		this.max = Integer.MIN_VALUE;
	}

	@Override
	public void add(Object value) {
		if (value == null) return;
		synchronized (this) {
			this.count++;
			this.min = Math.min(this.min, (int) value);
			this.max = Math.max(this.max, (int) value);
		}
	}

	@Override
	public List<Cube.Indicator> indicators() {
		return List.of(
				indicator("count(" + name + ")", count),
				indicator("min(" + name + ")", minTime()),
				indicator("max(" + name + ")", maxTime())
		);
	}

	private LocalTime minTime() {
		return min == Integer.MAX_VALUE ? LocalTime.MAX : LocalTime.ofSecondOfDay(min);
	}

	private LocalTime maxTime() {
		return max == Integer.MIN_VALUE ? LocalTime.MIN : LocalTime.ofSecondOfDay(max);
	}
}
