package io.intino.sumus.engine.builders.accumulators;

import io.intino.sumus.engine.Cube;

import java.util.List;

import static io.intino.sumus.engine.Cube.indicator;

public class IntegerAccumulator extends BuilderAccumulator {
	private int count;
	private long sum;
	private long min;
	private long max;

	public IntegerAccumulator(String name) {
		super(name);
		this.count = 0;
		this.sum = 0;
		this.min = Long.MAX_VALUE;
		this.max = Long.MIN_VALUE;
	}

	@Override
	public void add(Object value) {
		if (value == null) return;
		synchronized (this) {
			this.count++;
			this.sum = this.sum + (long) value;
			this.min = Math.min(this.min, (long) value);
			this.max = Math.max(this.max, (long) value);
		}
	}

	@Override
	public List<Cube.Indicator> indicators() {
		return List.of(
				indicator("count(" + name + ")", count),
				indicator("ratio(" + name + ")", (double) count/total),
				indicator("sum(" + name + ")", sum),
				indicator("average(" + name + ")", count > 0 ? (double) sum / count : 0),
				indicator("min(" + name + ")", min),
				indicator("max(" + name + ")", max)
		);
	}
}
