package io.intino.sumus.engine.builders.accumulators;

import io.intino.sumus.engine.builders.Accumulator;
import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.builders.CellBuilder;

import java.util.List;

import static io.intino.sumus.engine.Cube.indicator;

public abstract class BuilderAccumulator implements Accumulator {
	public final String name;
	protected int total;
	protected int count;

	public BuilderAccumulator(String name) {
		this.name = name;
		this.count = 0;
	}

	@Override
	public String name() {
		return name;
	}

	@Override
	public void add() {
		synchronized (this) {
			this.total++;
		}
	}

}
