package io.intino.sumus.engine;

import io.intino.sumus.engine.helpers.Finder;
import io.intino.sumus.model.AttributeDefinition;

import java.util.List;

public interface Dimension {
	String name();

	AttributeDefinition.Type type();
	boolean hasNA();
	default int levels() { return 1; }
	default List<Slice> slices(int level) { return slices(); }
	List<Slice> slices();
	default Slice slice(String name) { return new Finder<>(slices()).find(name); }
	default boolean isOrdinal() { return type().isOrdinal();}
}
