/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.parser;

import io.intino.sumus.engine.SumusException;
import io.intino.sumus.engine.parser.AttributeDefinition;
import io.intino.sumus.engine.parser.IndicatorDefinition;
import io.intino.sumus.engine.parser.PropertyDefinition;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class LedgerDefinition {
    public final List<AttributeDefinition> attributes;
    public final List<IndicatorDefinition> indicators;
    public final List<PropertyDefinition> properties = new ArrayList<PropertyDefinition>();

    public LedgerDefinition() {
        this.attributes = new ArrayList<AttributeDefinition>();
        this.indicators = new ArrayList<IndicatorDefinition>();
    }

    public boolean contains(String name) {
        for (AttributeDefinition attribute : this.attributes) {
            if (!attribute.name.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public AttributeDefinition attribute(String name) {
        return this.attributes.stream().filter(a -> a.name.equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public static LedgerDefinition read(File file) throws IOException {
        return LedgerDefinition.read(Files.readString(file.toPath()));
    }

    public static LedgerDefinition read(String content) {
        return new Parser(content).parse().get();
    }

    static class Parser {
        private final String content;
        private final LedgerDefinition definition;
        private State state;
        private AttributeDefinition attribute;
        private IndicatorDefinition indicator;
        private PropertyDefinition propertyDefinition;
        private int idx = 0;
        private int line = 1;
        private char c;
        private boolean block = false;

        public Parser(String content) {
            this.content = content;
            this.definition = new LedgerDefinition();
            this.state = this::acceptAttribute;
        }

        private State acceptAttribute(String token) {
            if (token.equalsIgnoreCase("properties")) {
                return this::acceptProperty;
            }
            if (token.equalsIgnoreCase("attributes")) {
                return this::acceptAttribute;
            }
            if (token.equalsIgnoreCase("indicators")) {
                return this::acceptIndicator;
            }
            if (this.definition.contains(token)) {
                throw new ParserException("Attribute " + token + " already exists");
            }
            this.attribute = new AttributeDefinition(token);
            this.definition.attributes.add(this.attribute);
            return this::acceptAttributeType;
        }

        private State acceptAttributeType(String token) {
            this.attribute.type(token);
            return this::acceptAttributeProperties;
        }

        private State acceptAttributeProperties(String token) {
            if (this.c != ']') {
                return this.acceptAttribute(token);
            }
            switch (this.attribute.type) {
                case number: 
                case integer: {
                    this.attribute.dimension(token);
                    break;
                }
                case url: {
                    this.attribute.urlBasePath = token;
                }
                case key: {
                    this.attribute.keyMasterLedger = token;
                }
            }
            return this::acceptAttributeProperties;
        }

        private State acceptIndicator(String token) {
            if (token.equalsIgnoreCase("properties")) {
                return this::acceptProperty;
            }
            if (token.equalsIgnoreCase("attributes")) {
                return this::acceptAttribute;
            }
            if (token.equalsIgnoreCase("indicators")) {
                return this::acceptIndicator;
            }
            this.indicator = new IndicatorDefinition(token);
            this.definition.indicators.add(this.indicator);
            return this::acceptIndicatorFormula;
        }

        private State acceptIndicatorFormula(String token) {
            this.indicator.formula(token, this.attributes());
            this.definition.attribute((String)this.indicator.attribute()).isUsedInIndicators = true;
            return this::acceptIndicatorOptions;
        }

        private State acceptIndicatorOptions(String token) {
            if (this.c != ']') {
                return this.acceptIndicator(token);
            }
            if (token.contains("/")) {
                this.indicator.ratio(token);
            } else {
                this.indicator.units(token);
            }
            return this::acceptIndicatorOptions;
        }

        private List<String> attributes() {
            return this.definition.attributes.stream().map(a -> a.name).collect(Collectors.toList());
        }

        private State acceptProperty(String token) {
            if (token.equalsIgnoreCase("properties")) {
                return this::acceptProperty;
            }
            if (token.equalsIgnoreCase("attributes")) {
                return this::acceptAttribute;
            }
            if (token.equalsIgnoreCase("indicators")) {
                return this::acceptIndicator;
            }
            this.propertyDefinition = new PropertyDefinition(token);
            this.definition.properties.add(this.propertyDefinition);
            return this::acceptPropertyValue;
        }

        private State acceptPropertyValue(String token) {
            this.propertyDefinition.value(token);
            return this::acceptProperty;
        }

        public LedgerDefinition get() {
            return this.definition;
        }

        public Parser parse() {
            String token;
            while ((token = this.nextToken()) != null) {
                this.process(token);
            }
            return this;
        }

        private void process(String token) {
            try {
                this.state = this.state.accepts(token);
            }
            catch (SumusException e) {
                e.line(this.line);
                throw e;
            }
        }

        private String nextToken() {
            StringBuilder result = new StringBuilder();
            while (this.idx < this.content.length()) {
                this.c = this.content.charAt(this.idx++);
                if (this.c == '\n') {
                    ++this.line;
                }
                if (this.block) {
                    if (this.c == '\n') {
                        throw new ParserException("Line end with an open block at line " + this.line);
                    }
                    if (this.c == '[') {
                        throw new ParserException("Opening a block inside a block at line " + this.line);
                    }
                    if (this.c == ']') {
                        this.block = false;
                        break;
                    }
                } else {
                    if (this.c == ']') {
                        throw new ParserException("Closing a block that is not open at line " + this.line);
                    }
                    if (Parser.isSeparator(this.c)) {
                        if (this.c == '[') {
                            this.block = true;
                        }
                        if (this.clean(result) != null) break;
                        continue;
                    }
                }
                result.append(this.c);
            }
            return this.clean(result);
        }

        private static boolean isSeparator(char c) {
            return "\t\n:[".indexOf(c) >= 0;
        }

        private String clean(StringBuilder sb) {
            String value = sb.toString().trim();
            return value.isEmpty() ? null : value;
        }

        private static class ParserException
        extends RuntimeException {
            public ParserException(String message) {
                super(message);
            }
        }

        private static interface State {
            public State accepts(String var1);
        }
    }
}

