/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.parser;

import io.intino.sumus.engine.SumusException;
import java.util.Arrays;
import java.util.List;

public class IndicatorDefinition {
    public final String name;
    public final boolean visibility;
    public String formula = "";
    public String units = "";
    public double ratio = 1.0;
    private static final List<String> formulas = List.of("_count(", "_ratio(", "_sum(", "_avg(", "_max(", "_min");

    public IndicatorDefinition(String name) {
        this.name = this.clean(name);
        this.visibility = this.firstCharOf(name) != '-';
    }

    private String clean(String name) {
        return this.hasVisibility(name) ? name.substring(1).trim() : name;
    }

    private boolean hasVisibility(String name) {
        char firstChar = this.firstCharOf(name);
        return firstChar == '+' || firstChar == '-';
    }

    private char firstCharOf(String name) {
        return name.charAt(0);
    }

    public void formula(String value, List<String> attributes) {
        this.checkFormula(value, attributes);
        this.formula = value;
    }

    public void units(String value) {
        this.units = value;
    }

    public void ratio(String token) {
        double[] a = Arrays.stream(token.split("/")).mapToDouble(Double::parseDouble).toArray();
        this.ratio = a[1] / a[0];
    }

    private void checkFormula(String token, List<String> attributes) {
        if (formulas.stream().noneMatch(token::startsWith)) {
            throw new SumusException("Unknown formula: " + token);
        }
        if (attributes.stream().noneMatch(a -> token.contains("(" + a + ")"))) {
            throw new SumusException("Unknown attribute in formula: " + token);
        }
    }

    public String attribute() {
        return this.formula.substring(this.formula.indexOf(40) + 1, this.formula.indexOf(41));
    }
}

