/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.parser;

import io.intino.sumus.engine.Attribute;
import io.intino.sumus.engine.Classifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class DimensionDefinition {
    private final String name;
    private final Attribute.Type type;
    private final Classifier classifier;

    public DimensionDefinition(String name, Attribute.Type type, String options) {
        this.name = name;
        this.type = type;
        this.classifier = type.isNumeric() ? this.numericalClassifier(this.asLongs(options)) : this.categoricalClassifier(this.asCategories(options));
    }

    private Classifier categoricalClassifier(final String[] options) {
        return new Classifier(){

            @Override
            public List<String> categories() {
                return null;
            }

            @Override
            public Predicate<Object> predicateOf(String category) {
                return null;
            }

            public String toString() {
                return Arrays.toString(options);
            }
        };
    }

    public String name() {
        return this.name;
    }

    public Classifier classifier() {
        return this.classifier;
    }

    private Classifier numericalClassifier(Long[] longs) {
        List<String> categories = this.categoriesOf(longs);
        Map<String, Predicate<Object>> predicates = IntStream.range(0, categories.size()).boxed().collect(Collectors.toMap(categories::get, i -> this.predicate(longs[i], longs[i + 1])));
        return this.classifier(categories, predicates);
    }

    private List<String> categoriesOf(Long[] longs) {
        return IntStream.range(0, longs.length - 1).mapToObj(i -> DimensionDefinition.clean("[" + longs[i] + ".." + longs[i + 1] + "]")).collect(Collectors.toList());
    }

    private Long[] asLongs(String options) {
        return (Long[])Arrays.stream(options.split(",")).map(DimensionDefinition::parse).toArray(Long[]::new);
    }

    private String[] asCategories(String options) {
        return (String[])Arrays.stream(options.split(",")).map(String::trim).toArray(String[]::new);
    }

    private static String clean(String value) {
        return value.replace("null", "");
    }

    private Classifier classifier(final List<String> categories, final Map<String, Predicate<Object>> predicates) {
        return new Classifier(){

            @Override
            public List<String> categories() {
                return categories;
            }

            @Override
            public Predicate<Object> predicateOf(String category) {
                return predicates.getOrDefault(category, s -> false);
            }
        };
    }

    private Predicate<Object> predicate(Long a, Long b) {
        return this.type == Attribute.Type.integer ? v -> !(DimensionDefinition.isNull(v) || !DimensionDefinition.isNull(a) && (Long)v < a || !DimensionDefinition.isNull(b) && (Long)v >= b) : v -> !DimensionDefinition.isNull(v) && (DimensionDefinition.isNull(a) || (Double)v >= (double)a.longValue()) && (DimensionDefinition.isNull(b) || (Double)v < (double)b.longValue());
    }

    private static boolean isNull(Object value) {
        return value == null;
    }

    private static Long parse(String s) {
        try {
            return Long.parseLong(s.trim());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public String toString() {
        return this.name + this.classifier.toString().replace(" ", "");
    }
}

