/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.parser;

import io.intino.sumus.engine.Attribute;
import io.intino.sumus.engine.SumusException;
import io.intino.sumus.engine.parser.DimensionDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AttributeDefinition {
    public final String name;
    public Attribute.Type type;
    public boolean isUsedInIndicators = false;
    public List<DimensionDefinition> dimensions;
    public String urlBasePath = "";
    public String keyMasterLedger = "";

    public AttributeDefinition(String name, Attribute.Type type) {
        this.name = name;
        this.type = type;
        this.dimensions = new ArrayList<DimensionDefinition>();
    }

    public AttributeDefinition(String name) {
        this(name, Attribute.Type.label);
    }

    public String toString() {
        return this.name + ":" + this.type;
    }

    public void type(String value) {
        try {
            this.type = Attribute.Type.valueOf(value.toLowerCase());
        }
        catch (IllegalArgumentException e) {
            throw new SumusException(String.format("Unknown type '%s'. Valid types: %s", value, Arrays.toString((Object[])Attribute.Type.values())));
        }
    }

    public void dimension(String token) {
        this.dimensions.add(new DimensionDefinition(this.nextName(), this.type, token));
    }

    private String nextName() {
        return String.valueOf((char)(49 + this.dimensions.size()));
    }
}

