/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.ledgers.columnar;

import io.intino.sumus.engine.Attribute;
import io.intino.sumus.engine.Fact;
import io.intino.sumus.engine.Ledger;
import io.intino.sumus.engine.LedgerDecorator;
import io.intino.sumus.engine.ledgers.columnar.Column;
import io.intino.sumus.engine.ledgers.columnar.ColumnarLedger;
import io.intino.sumus.engine.parser.LedgerDefinition;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class ColumnarLedgerDecorator
implements LedgerDecorator {
    private static final String ID = "id";
    private static final String TAB = "\t";
    private static final String TSV_EXTENSION = ".tsv";
    public static final String LEDGER_EXTENSION = ".ledger";
    private final File root;
    private final Map<String, Master> masters = new HashMap<String, Master>();

    public ColumnarLedgerDecorator(File root) {
        this.root = root;
    }

    @Override
    public ColumnarLedger decorate(Ledger ledger) {
        ColumnarLedger columnarLedger = (ColumnarLedger)ledger;
        ColumnarLedger result = new ColumnarLedger(columnarLedger.definition());
        this.mastersOf(ledger.definition()).forEach(master -> this.join(columnarLedger, (Master)master, result));
        columnarLedger.columns.forEach(result::add);
        result.removeColumnIf(c -> c.type() == Attribute.Type.key);
        return result;
    }

    private void join(ColumnarLedger ledger, Master master, ColumnarLedger result) {
        for (MasterColumn column : master.columns(ledger)) {
            result.add(column);
        }
    }

    private Stream<Master> mastersOf(LedgerDefinition definition) {
        return this.masterLedgersDeclarationsOf(definition).peek(this::loadMasterIfNotExists).map(this.masters::get);
    }

    private void loadMasterIfNotExists(String name) {
        try {
            if (this.masters.containsKey(name)) {
                return;
            }
            ColumnarLedger ledger = this.decorate(this.ledgerOf(this.ledgerDefinitionOf(name)));
            this.read(ledger, new File(this.root, name + TSV_EXTENSION), TAB);
            this.masters.put(name, new Master(ledger));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ColumnarLedger ledgerOf(LedgerDefinition definition) {
        return new ColumnarLedger(definition);
    }

    private void read(Ledger ledger, File file, String separator) throws IOException {
        if (ledger instanceof ColumnarLedger) {
            ((ColumnarLedger)ledger).load(file, separator);
        }
    }

    private LedgerDefinition ledgerDefinitionOf(String name) {
        try {
            return LedgerDefinition.read(new File(this.root, name + LEDGER_EXTENSION));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Stream<String> masterLedgersDeclarationsOf(LedgerDefinition definition) {
        return definition.attributes.stream().filter(a -> a.type == Attribute.Type.key).map(a -> a.keyMasterLedger).filter(a -> !a.isEmpty());
    }

    public static class MasterColumn
    implements Column {
        private final Master master;
        private final Column primary;
        private final Column foreign;

        public MasterColumn(Master master, Column primary, Column foreign) {
            this.master = master;
            this.primary = primary;
            this.foreign = foreign;
        }

        @Override
        public Attribute attribute() {
            return this.primary.attribute();
        }

        @Override
        public String name() {
            return this.primary.name();
        }

        @Override
        public Attribute.Type type() {
            return this.primary.type();
        }

        @Override
        public boolean hasNA() {
            return this.foreign.hasNA() || this.primary.hasNA();
        }

        @Override
        public List<Object> uniques() {
            return this.primary.uniques();
        }

        @Override
        public Object min() {
            return this.primary.min();
        }

        @Override
        public Object max() {
            return this.primary.max();
        }

        @Override
        public int size() {
            return this.foreign.size();
        }

        @Override
        public Object value(int idx) {
            return this.master.get(this.idOf(idx)).value(this.attribute());
        }

        private String idOf(int idx) {
            return (String)this.foreign.value(idx);
        }

        public String toString() {
            return this.type().name() + " " + this.name();
        }
    }

    private static class Master {
        private final ColumnarLedger ledger;
        private final Map<String, Fact> facts;

        public Master(ColumnarLedger ledger) {
            this.ledger = ledger;
            this.facts = new HashMap<String, Fact>(ledger.size());
            ledger.facts().forEach(f -> this.facts.put(this.idOf((Fact)f), (Fact)f));
        }

        public Fact get(Fact fact) {
            return this.get(this.idOf(fact));
        }

        public Fact get(String id) {
            return this.facts.get(id);
        }

        public Attribute[] attributes() {
            return (Attribute[])this.ledger.attributes().stream().filter(a -> a.type != Attribute.Type.key).toArray(Attribute[]::new);
        }

        private String idOf(Fact f) {
            return String.valueOf(f.value(ColumnarLedgerDecorator.ID));
        }

        public MasterColumn[] columns(ColumnarLedger ledger) {
            Column foreign = ledger.column(ColumnarLedgerDecorator.ID);
            return (MasterColumn[])this.ledger.columns.stream().map(c -> new MasterColumn(this, (Column)c, foreign)).toArray(MasterColumn[]::new);
        }
    }
}

