/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.ledgers.columnar;

import io.intino.sumus.engine.Attribute;
import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.Dimension;
import io.intino.sumus.engine.Fact;
import io.intino.sumus.engine.Filter;
import io.intino.sumus.engine.Ledger;
import io.intino.sumus.engine.builders.CubeBuilder;
import io.intino.sumus.engine.dimensions.CategoricalDimension;
import io.intino.sumus.engine.dimensions.DayOfWeekDimension;
import io.intino.sumus.engine.dimensions.MonthOfYearDimension;
import io.intino.sumus.engine.dimensions.NumericalDimension;
import io.intino.sumus.engine.dimensions.YearDimension;
import io.intino.sumus.engine.ledgers.columnar.Column;
import io.intino.sumus.engine.ledgers.columnar.columns.DataColumn;
import io.intino.sumus.engine.parser.AttributeDefinition;
import io.intino.sumus.engine.parser.DimensionDefinition;
import io.intino.sumus.engine.parser.LedgerDefinition;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ColumnarLedger
implements Ledger {
    public final LedgerDefinition definition;
    public final List<Column> columns;
    public final List<Dimension> dimensions;
    private final Map<String, Column> columnMap = new HashMap<String, Column>();
    private int size;

    public ColumnarLedger(LedgerDefinition definition) {
        this.definition = definition;
        this.columns = new ArrayList<Column>();
        this.dimensions = new ArrayList<Dimension>();
    }

    @Override
    public LedgerDefinition definition() {
        return this.definition;
    }

    public ColumnarLedger load(File file, String separator) throws IOException {
        return this.load(this.read(file, separator));
    }

    public ColumnarLedger load(String[][] data) {
        this.loadingWith(this.transpose(data)).forEach(f -> this.add(this.columnOf((Future<Column>)f)));
        return this;
    }

    private List<Future<Column>> loadingWith(String[][] data) {
        ArrayList<Future<Column>> futures = new ArrayList<Future<Column>>();
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        for (int i = 0; i < this.definition.attributes.size(); ++i) {
            Attribute attribute = this.attributeOf(i);
            String[] values = data[i];
            futures.add(executor.submit(() -> new DataColumn(attribute, values)));
        }
        this.terminate(executor);
        return futures;
    }

    private String[][] read(File file, String separator) throws IOException {
        try (Stream<String> lines = Files.lines(file.toPath());){
            String[][] stringArray = (String[][])lines.map(l -> l.split(separator)).toArray(x$0 -> new String[x$0][]);
            return stringArray;
        }
    }

    private void terminate(ExecutorService executor) {
        try {
            executor.shutdown();
            executor.awaitTermination(40L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private Column columnOf(Future<Column> future) {
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return null;
        }
    }

    private Attribute attributeOf(int i) {
        AttributeDefinition definition = this.definition.attributes.get(i);
        return new Attribute(definition);
    }

    private String[][] transpose(String[][] rows) {
        String[][] columns = this.initColumns(rows.length);
        for (int i = 0; i < rows.length; ++i) {
            String[] row = rows[i];
            for (int j = 0; j < row.length; ++j) {
                columns[j][i] = row[j];
            }
        }
        return columns;
    }

    private String[][] initColumns(int size) {
        return new String[this.definition.attributes.size()][size];
    }

    public ColumnarLedger add(Column column) {
        if (column == null) {
            return this;
        }
        if (this.columns.isEmpty()) {
            this.size = column.size();
        }
        this.columns.add(column);
        this.dimensions.addAll(this.dimensionsOf(column));
        this.columnMap.put(column.name(), column);
        return this;
    }

    public void removeColumnIf(Predicate<Column> condition) {
        List columnsToRemove = this.columns.stream().filter(condition).collect(Collectors.toList());
        for (Column column : columnsToRemove) {
            this.columns.remove(column);
            this.columnMap.remove(column.name());
        }
    }

    private List<Dimension> dimensionsOf(Column column) {
        if (column.type() == Attribute.Type.category) {
            return this.categoricalDimensionsOf(column);
        }
        if (column.type() == Attribute.Type.date) {
            return this.dateDimensionsOf(column);
        }
        if (column.type().isNumeric()) {
            return this.numericDimensionsOf(column);
        }
        return Collections.emptyList();
    }

    private List<Dimension> categoricalDimensionsOf(Column column) {
        return List.of(new CategoricalDimension(column));
    }

    private List<Dimension> dateDimensionsOf(Column column) {
        return List.of(new YearDimension(column), new MonthOfYearDimension(column), new DayOfWeekDimension(column));
    }

    private List<Dimension> numericDimensionsOf(Column column) {
        return Arrays.stream(column.attribute().dimensions).map(d -> this.dimension(column, (DimensionDefinition)d)).collect(Collectors.toList());
    }

    private Dimension dimension(Column column, DimensionDefinition definition) {
        return new NumericalDimension(column, definition.name(), definition.classifier());
    }

    @Override
    public Ledger.Query cube() {
        return new Ledger.Query(){
            private List<Dimension> dimensions = Collections.emptyList();
            private Filter filter = Filter.None;

            @Override
            public Ledger.Query filter(Filter filter) {
                this.filter = filter;
                return this;
            }

            @Override
            public Ledger.Query dimensions(List<Dimension> dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            @Override
            public Cube build() {
                return new CubeBuilder((Ledger)ColumnarLedger.this, this.filter, this.dimensions).build();
            }
        };
    }

    @Override
    public Iterable<Fact> facts(Filter filter) {
        return () -> new FactIterator(filter);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public List<Attribute> attributes() {
        return this.columns.stream().map(Column::attribute).collect(Collectors.toList());
    }

    @Override
    public List<Dimension> dimensions() {
        return this.dimensions;
    }

    Column column(String name) {
        return this.columnMap.getOrDefault(name, Column.Null);
    }

    private class FactIterator
    implements Iterator<Fact> {
        private final Filter filter;
        private int idx = 0;
        private Fact fact;

        public FactIterator(Filter filter) {
            this.filter = filter;
            this.fact = this.nextFact();
        }

        @Override
        public boolean hasNext() {
            return this.fact != null;
        }

        @Override
        public Fact next() {
            Fact result = this.fact;
            this.fact = this.nextFact();
            return result;
        }

        private Fact nextFact() {
            while (this.idx < ColumnarLedger.this.size) {
                if (!this.filter.accepts(this.idx++)) continue;
                return this.fact(this.idx - 1);
            }
            return null;
        }

        private Fact fact(final int idx) {
            return new Fact(){

                @Override
                public int idx() {
                    return idx;
                }

                @Override
                public List<Attribute> attributes() {
                    return ColumnarLedger.this.attributes();
                }

                @Override
                public Object value(String attribute) {
                    return ColumnarLedger.this.column(attribute).value(idx);
                }

                public String toString() {
                    return this.attributes().stream().map(a -> a.name + ":" + this.format(this.value(a.name))).collect(Collectors.joining(","));
                }

                private Object format(Object value) {
                    return value == null ? "" : value.toString();
                }
            };
        }
    }
}

