/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.dimensions;

import io.intino.sumus.engine.Attribute;
import io.intino.sumus.engine.Lookup;
import io.intino.sumus.engine.Slice;
import io.intino.sumus.engine.SumusException;
import io.intino.sumus.engine.dimensions.AbstractDimension;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class YearDimension
extends AbstractDimension {
    public YearDimension(Lookup lookup) {
        super(lookup);
        this.slices.addAll(this.buildSlices());
        if (lookup.hasNA()) {
            this.slices.add(new AbstractDimension.DimensionSlice());
        }
    }

    private List<Slice> buildSlices() {
        return this.years().boxed().map(this::sliceOf).collect(Collectors.toList());
    }

    @Override
    public String name() {
        return this.lookup.name() + "-year";
    }

    @Override
    protected void check() {
        if (this.lookup.type() == Attribute.Type.date) {
            return;
        }
        throw new SumusException("DayOfWeek dimension must use a date column");
    }

    private Slice sliceOf(int year) {
        return new AbstractDimension.DimensionSlice(String.valueOf(year), v -> this.match(year, v));
    }

    private boolean match(int year, Object value) {
        return value instanceof Long && LocalDate.ofEpochDay((Long)value).getYear() == year;
    }

    private IntStream years() {
        try {
            int min = LocalDate.ofEpochDay((Long)this.lookup.min()).getYear();
            int max = LocalDate.ofEpochDay((Long)this.lookup.max()).getYear();
            return IntStream.range(min, max + 1);
        }
        catch (Exception e) {
            return IntStream.empty();
        }
    }
}

